/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.completion.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Version;
import org.genemania.completion.CompletionConsumer;
import org.genemania.completion.CompletionProvider;
import org.genemania.mediator.lucene.AbstractCollector;

@Deprecated
public abstract class LuceneCompletionProvider
implements CompletionProvider {
    protected final IndexSearcher searcher;
    protected final QueryParser parser;
    protected final IndexReader reader;
    protected final String defaultField;
    private final Analyzer analyzer;

    public LuceneCompletionProvider(IndexReader reader, String defaultField, Analyzer analyzer) {
        this.reader = reader;
        this.searcher = reader != null ? new IndexSearcher(reader) : null;
        this.parser = analyzer != null ? new QueryParser(Version.LUCENE_29, defaultField, analyzer) : null;
        this.defaultField = defaultField;
        this.analyzer = analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeProposals(final CompletionConsumer consumer, String queryString) {
        try {
            if (queryString.length() == 0) {
                return;
            }
            PrefixQuery query = new PrefixQuery(new Term(this.defaultField, queryString));
            this.searcher.search((Query)query, (Collector)new AbstractCollector(){

                @Override
                public void handleHit(int id) {
                    try {
                        Document document = LuceneCompletionProvider.this.searcher.doc(id);
                        consumer.consume(document.get(LuceneCompletionProvider.this.defaultField));
                    }
                    catch (IOException e) {
                        LuceneCompletionProvider.this.log(e);
                    }
                }
            });
        }
        catch (IOException e) {
            this.log(e);
        }
        catch (BooleanQuery.TooManyClauses e) {
            consumer.tooManyCompletions();
        }
        finally {
            consumer.finish();
        }
    }

    protected void log(Throwable e) {
    }

    @Override
    public void close() {
        try {
            this.searcher.close();
        }
        catch (IOException e) {
            this.log(e);
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            this.log(e);
        }
    }

    @Override
    public boolean isValid(String proposal) {
        return this.getCanonicalForm(proposal) != null;
    }

    @Override
    public String getCanonicalForm(String proposal) {
        try {
            if (proposal.length() == 0) {
                return null;
            }
            Query query = this.parser.parse(String.format("\"%s\"", proposal));
            TopDocs topDocs = this.searcher.search(query, 1);
            if (topDocs.totalHits > 0) {
                Document document = this.searcher.doc(topDocs.scoreDocs[0].doc);
                return document.get(this.defaultField);
            }
            return null;
        }
        catch (IOException e) {
            this.log(e);
        }
        catch (ParseException e) {
            this.log(e);
        }
        catch (BooleanQuery.TooManyClauses e) {
            this.log(e);
        }
        return null;
    }

    public TokenStream analyze(String text) throws IOException {
        return this.analyzer.reusableTokenStream(this.defaultField, (Reader)new StringReader(text));
    }
}

