/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.normalizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.type.DataLayout;
import org.genemania.type.ImportedDataFormat;
import org.genemania.type.NetworkProcessingMethod;

public class DataFileClassifier {
    public void classify(DataImportSettings result, InputStream stream, int maxLinesToSample) throws IOException {
        for (String delimiter : new String[]{"\t", ","}) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            HashMap<Integer, Integer> entriesPerLine = new HashMap<Integer, Integer>();
            int linesRead = 0;
            for (int i = 0; i < maxLinesToSample && (line = reader.readLine()) != null; ++i) {
                String[] parts = line.split(delimiter);
                int key = parts.length;
                int value = entriesPerLine.containsKey(key) ? (Integer)entriesPerLine.get(key) + 1 : 1;
                entriesPerLine.put(key, value);
                ++linesRead;
            }
            Map.Entry entry = this.getMostFrequent(entriesPerLine);
            if (entry == null) continue;
            int columns = (Integer)entry.getKey();
            double score = (double)entry.getValue().intValue() / (double)linesRead;
            if (columns == 2 && score > 0.5) {
                result.dataFormat = ImportedDataFormat.NETWORK_DATA_TAB_DELIMITED;
                result.dataLayout = DataLayout.BINARY_NETWORK;
                result.processingMethod = NetworkProcessingMethod.DIRECT;
                result.setDelimiter(delimiter);
                return;
            }
            if (columns == 3 && score > 0.5) {
                result.dataFormat = ImportedDataFormat.NETWORK_DATA_TAB_DELIMITED;
                result.dataLayout = DataLayout.WEIGHTED_NETWORK;
                result.processingMethod = NetworkProcessingMethod.DIRECT;
                result.setDelimiter(delimiter);
                return;
            }
            if (columns <= 3 || !(score > 0.5)) continue;
            result.dataFormat = ImportedDataFormat.PROFILE_DATA_TAB_DELIMITED;
            result.dataLayout = DataLayout.GEO_PROFILE;
            result.processingMethod = NetworkProcessingMethod.PEARSON;
            result.setDelimiter(delimiter);
            return;
        }
        result.dataFormat = ImportedDataFormat.UNKNOWN;
        result.dataLayout = DataLayout.UNKNOWN;
        result.processingMethod = NetworkProcessingMethod.UNKNOWN;
    }

    <T> Map.Entry<T, Integer> getMostFrequent(Map<T, Integer> frequencies) {
        int maxCount = 0;
        Map.Entry<T, Integer> mostFrequent = null;
        for (Map.Entry<T, Integer> entry : frequencies.entrySet()) {
            if (entry.getValue() <= maxCount) continue;
            maxCount = entry.getValue();
            mostFrequent = entry;
        }
        return mostFrequent;
    }
}

