/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.normalizer;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.genemania.data.normalizer.BinaryNetworkNormalizer;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.data.normalizer.GeoProfileNormalizer;
import org.genemania.data.normalizer.INormalizer;
import org.genemania.data.normalizer.NormalizationResult;
import org.genemania.data.normalizer.WeightedNetworkNormalizer;
import org.genemania.exception.ApplicationException;
import org.genemania.type.DataLayout;
import org.genemania.util.ProgressReporter;

public class DataNormalizer {
    static Map<DataLayout, INormalizer> normalizers = new HashMap<DataLayout, INormalizer>();

    public NormalizationResult normalize(DataImportSettings classification, GeneCompletionProvider2 genes, Reader input, Writer output, ProgressReporter progress) throws IOException, ApplicationException {
        INormalizer normalizer = normalizers.get(classification.dataLayout);
        if (normalizer == null) {
            return null;
        }
        return normalizer.normalize(classification, genes, input, output, progress);
    }

    static {
        normalizers.put(DataLayout.WEIGHTED_NETWORK, new WeightedNetworkNormalizer());
        normalizers.put(DataLayout.GEO_PROFILE, new GeoProfileNormalizer());
        normalizers.put(DataLayout.PROFILE, new GeoProfileNormalizer());
        normalizers.put(DataLayout.BINARY_NETWORK, new BinaryNetworkNormalizer());
    }
}

