/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.normalizer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.genemania.completion.CompletionConsumer;
import org.genemania.completion.CompletionProvider;
import org.genemania.domain.Gene;
import org.genemania.domain.Organism;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.LuceneGeneMediator;

public class GeneCompletionProvider2
implements CompletionProvider {
    private Organism organism;
    private LuceneGeneMediator mediator;
    private Searcher searcher;
    private Analyzer analyzer;

    public GeneCompletionProvider2(Searcher searcher, Analyzer analyzer, Organism organism) {
        this.organism = organism;
        this.searcher = searcher;
        this.mediator = new LuceneGeneMediator(searcher, analyzer);
        this.analyzer = analyzer;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeProposals(final CompletionConsumer consumer, String queryString) {
        try {
            if (queryString.length() == 0) {
                return;
            }
            TokenStream stream = this.analyzer.tokenStream("gene", (Reader)new StringReader(queryString));
            TermAttribute term = (TermAttribute)stream.getAttribute(TermAttribute.class);
            if (!stream.incrementToken()) {
                return;
            }
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term("gene_organism_id", String.valueOf(this.organism.getId()))), BooleanClause.Occur.MUST);
            query.add((Query)new PrefixQuery(new Term("gene", term.term())), BooleanClause.Occur.MUST);
            this.searcher.search((Query)query, (Collector)new AbstractCollector(){

                @Override
                public void handleHit(int id) {
                    try {
                        Document document = GeneCompletionProvider2.this.searcher.doc(id);
                        consumer.consume(document.get("gene"));
                    }
                    catch (IOException e) {
                        GeneCompletionProvider2.this.log(e);
                    }
                }
            });
        }
        catch (IOException e) {
            this.log(e);
        }
        catch (BooleanQuery.TooManyClauses e) {
            consumer.tooManyCompletions();
        }
        finally {
            consumer.finish();
        }
    }

    @Override
    public String getCanonicalForm(String proposal) {
        return this.mediator.getCanonicalSymbol(this.organism.getId(), proposal);
    }

    @Override
    public boolean isValid(String proposal) {
        return this.mediator.isValid(this.organism.getId(), proposal);
    }

    public Gene getGene(String symbol) {
        return this.mediator.getGeneForSymbol(this.organism, symbol);
    }

    public Long getNodeId(String symbol) {
        return this.mediator.getNodeId(this.organism.getId(), symbol);
    }

    private void log(IOException e) {
        e.printStackTrace();
    }
}

