/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.domain;

import java.util.Collection;
import java.util.LinkedList;
import org.genemania.domain.Attribute;
import org.genemania.domain.ResultAttributeGroup;

public class ResultAttribute {
    private double weight;
    private Attribute attribute;
    private ResultAttributeGroup resultAttributeGroup;
    private int numAnnotatedInSample;
    private int numAnnotatedInTotal;
    private Collection<Link> links = new LinkedList<Link>();

    public ResultAttribute(Attribute attribute, ResultAttributeGroup resultAttributeGroup, double weight, int numAnnotatedInSample, int numAnnotatedInTotal) {
        this.attribute = attribute;
        this.resultAttributeGroup = resultAttributeGroup;
        this.weight = weight;
        this.numAnnotatedInSample = numAnnotatedInSample;
        this.numAnnotatedInTotal = numAnnotatedInTotal;
    }

    public ResultAttribute() {
    }

    public int getNumAnnotatedInSample() {
        return this.numAnnotatedInSample;
    }

    public void setNumAnnotatedInSample(int numAnnotatedInSample) {
        this.numAnnotatedInSample = numAnnotatedInSample;
    }

    public int getNumAnnotatedInTotal() {
        return this.numAnnotatedInTotal;
    }

    public void setNumAnnotatedInTotal(int numAnnotatedInTotal) {
        this.numAnnotatedInTotal = numAnnotatedInTotal;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public ResultAttributeGroup getResultAttributeGroup() {
        return this.resultAttributeGroup;
    }

    public void setResultAttributeGroup(ResultAttributeGroup resultAttributeGroup) {
        this.resultAttributeGroup = resultAttributeGroup;
    }

    public Collection<Link> getLinks() {
        return this.links;
    }

    public void setLinks(Collection<Link> links) {
        this.links = links;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + this.numAnnotatedInSample;
        result = 31 * result + this.numAnnotatedInTotal;
        result = 31 * result + (this.resultAttributeGroup == null ? 0 : this.resultAttributeGroup.hashCode());
        long temp = Double.doubleToLongBits(this.weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResultAttribute other = (ResultAttribute)obj;
        if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
            return false;
        }
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.numAnnotatedInSample != other.numAnnotatedInSample) {
            return false;
        }
        if (this.numAnnotatedInTotal != other.numAnnotatedInTotal) {
            return false;
        }
        if (this.resultAttributeGroup == null ? other.resultAttributeGroup != null : !this.resultAttributeGroup.equals(other.resultAttributeGroup)) {
            return false;
        }
        return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }

    public String toString() {
        return "ResultAttribute [weight=" + this.weight + ", attribute=" + this.attribute + ", resultAttributeGroup=" + this.resultAttributeGroup + ", numAnnotatedInSample=" + this.numAnnotatedInSample + ", numAnnotatedInTotal=" + this.numAnnotatedInTotal + ", links=" + this.links + "]";
    }

    public static class Link {
        private String url;
        private String name;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Link(String name, String url) {
            this.url = url;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }
}

