/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dto;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.genemania.domain.Gene;
import org.genemania.domain.InteractionNetwork;
import org.genemania.type.CombiningMethod;

public class RelatedGenesWebRequestDto
implements Serializable {
    private static final long serialVersionUID = -5062149471128161811L;
    private long organismId;
    private Collection<Gene> inputGenes;
    private Collection<InteractionNetwork> inputNetworks;
    Collection<Long> attributeGroups;
    private int resultSize;
    private CombiningMethod combiningMethod;
    private String userDefinedNetworkNamespace;
    private long ontologyId;
    private int attributesLimit;

    public String toString() {
        String organismToken = "organism=" + this.getOrganismId() + ";";
        long[] genes = new long[this.getInputGenes().size()];
        String geneToken = "genes=";
        int i = 0;
        for (Gene gene : this.getInputGenes()) {
            genes[i++] = gene.getNode().getId();
        }
        Arrays.sort(genes);
        for (i = 0; i < genes.length; ++i) {
            geneToken = geneToken + genes[i] + (i < genes.length - 1 ? "," : "");
        }
        geneToken = geneToken + ";";
        String sizeToken = "size=" + this.getResultSize() + ";";
        String attrSizeToken = "attrSize=" + this.getAttributesLimit() + ";";
        String attributesGroupToken = "attributeGroups=";
        long[] attrGroups = new long[this.attributeGroups.size()];
        i = 0;
        for (Long group : this.attributeGroups) {
            attrGroups[i++] = group;
        }
        Arrays.sort(attrGroups);
        for (i = 0; i < attrGroups.length; ++i) {
            attributesGroupToken = attributesGroupToken + attrGroups[i] + (i < attrGroups.length - 1 ? "," : "");
        }
        attributesGroupToken = attributesGroupToken + ";";
        String networkToken = "networks=";
        long[] networks = new long[this.getInputNetworks().size()];
        i = 0;
        for (InteractionNetwork network : this.getInputNetworks()) {
            networks[i++] = network.getId();
        }
        Arrays.sort(networks);
        for (i = 0; i < networks.length; ++i) {
            networkToken = networkToken + networks[i] + (i < networks.length - 1 ? "," : "");
        }
        networkToken = networkToken + ";";
        String weightingToken = "weighting=" + this.getCombiningMethod() + ";";
        return organismToken + geneToken + networkToken + attributesGroupToken + weightingToken + sizeToken + attrSizeToken;
    }

    public long getOrganismId() {
        return this.organismId;
    }

    public void setOrganismId(long organismId) {
        this.organismId = organismId;
    }

    public Collection<Gene> getInputGenes() {
        return this.inputGenes;
    }

    public void setInputGenes(Collection<Gene> inputGenes) {
        this.inputGenes = inputGenes;
    }

    public Collection<InteractionNetwork> getInputNetworks() {
        return this.inputNetworks;
    }

    public void setInputNetworks(Collection<InteractionNetwork> inputNetworks) {
        this.inputNetworks = inputNetworks;
    }

    public CombiningMethod getCombiningMethod() {
        return this.combiningMethod;
    }

    public void setCombiningMethod(CombiningMethod combiningMethod) {
        this.combiningMethod = combiningMethod;
    }

    public String getUserDefinedNetworkNamespace() {
        return this.userDefinedNetworkNamespace;
    }

    public void setUserDefinedNetworkNamespace(String userDefinedNetworkNamespace) {
        this.userDefinedNetworkNamespace = userDefinedNetworkNamespace;
    }

    public long getOntologyId() {
        return this.ontologyId;
    }

    public void setOntologyId(long ontolgyId) {
        this.ontologyId = ontolgyId;
    }

    public Collection<Long> getAttributeGroups() {
        return this.attributeGroups;
    }

    public void setAttributeGroups(Collection<Long> attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    public int getResultSize() {
        return this.resultSize;
    }

    public void setResultSize(int resultSize) {
        this.resultSize = resultSize;
    }

    public int getAttributesLimit() {
        return this.attributesLimit;
    }

    public void setAttributesLimit(int attributesLimit) {
        this.attributesLimit = attributesLimit;
    }
}

