/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.Searcher;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.mediator.AttributeMediator;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.LuceneMediator;

public class LuceneAttributeMediator
extends LuceneMediator
implements AttributeMediator {
    public LuceneAttributeMediator(Searcher searcher, Analyzer analyzer) {
        super(searcher, analyzer);
    }

    @Override
    public List hqlSearch(String queryString) {
        return null;
    }

    @Override
    public Attribute findAttribute(long organismId, long attributeId) {
        final Attribute[] attribute = new Attribute[1];
        this.search(String.format("+%s:\"%d\" +%s:\"%d\"", "at_organism_id", organismId, "at_id", attributeId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneAttributeMediator.this.searcher.doc(doc);
                    attribute[0] = LuceneAttributeMediator.this.createAttribute(document);
                }
                catch (CorruptIndexException e) {
                    LuceneAttributeMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneAttributeMediator.this.log(e);
                }
            }
        });
        return attribute[0];
    }

    protected Attribute createAttribute(Document document) {
        Attribute attribute = new Attribute();
        attribute.setId(Long.parseLong(document.get("at_id")));
        attribute.setName(document.get("at_name"));
        attribute.setExternalId(document.get("at_external_id"));
        attribute.setDescription(document.get("at_description"));
        return attribute;
    }

    @Override
    public boolean isValidAttribute(long organismId, long attributeId) {
        final Long[] groupId = new Long[1];
        this.search(String.format("+%s:\"%d\"", "at_id", attributeId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneAttributeMediator.this.searcher.doc(doc);
                    groupId[0] = Long.parseLong(document.get("at_id"));
                }
                catch (CorruptIndexException e) {
                    LuceneAttributeMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneAttributeMediator.this.log(e);
                }
            }
        });
        if (groupId[0] == null) {
            return false;
        }
        final Long[] organism = new Long[1];
        this.search(String.format("+%s:\"%d\"", "atg_id", groupId[0]), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneAttributeMediator.this.searcher.doc(doc);
                    organism[0] = Long.parseLong(document.get("atg_organism_id"));
                }
                catch (CorruptIndexException e) {
                    LuceneAttributeMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneAttributeMediator.this.log(e);
                }
            }
        });
        if (organism[0] == null) {
            return false;
        }
        return organism[0].equals(organismId);
    }

    @Override
    public List<Attribute> findAttributesByGroup(long organismId, long attributeGroupId) {
        final ArrayList<Attribute> result = new ArrayList<Attribute>();
        this.search(String.format("+%s:\"%d\" +%s:\"%d\"", "at_organism_id", organismId, "at_atg_id", attributeGroupId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) throws IOException {
                try {
                    Document document = LuceneAttributeMediator.this.searcher.doc(doc);
                    result.add(LuceneAttributeMediator.this.createAttribute(document));
                }
                catch (CorruptIndexException e) {
                    LuceneAttributeMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneAttributeMediator.this.log(e);
                }
            }
        });
        return result;
    }

    @Override
    public List<AttributeGroup> findAttributeGroupsByOrganism(long organismId) {
        final ArrayList<AttributeGroup> result = new ArrayList<AttributeGroup>();
        this.search(String.format("+%s:\"%d\"", "atg_organism_id", organismId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) throws IOException {
                try {
                    Document document = LuceneAttributeMediator.this.searcher.doc(doc);
                    result.add(LuceneAttributeMediator.this.createAttributeGroup(document));
                }
                catch (CorruptIndexException e) {
                    LuceneAttributeMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneAttributeMediator.this.log(e);
                }
            }
        });
        return result;
    }

    @Override
    public AttributeGroup findAttributeGroup(long organismId, long attributeGroupId) {
        final AttributeGroup[] attributeGroup = new AttributeGroup[1];
        this.search(String.format("+%s:\"%d\" +%s:\"%d\"", "atg_id", attributeGroupId, "atg_organism_id", organismId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneAttributeMediator.this.searcher.doc(doc);
                    attributeGroup[0] = LuceneAttributeMediator.this.createAttributeGroup(document);
                }
                catch (CorruptIndexException e) {
                    LuceneAttributeMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneAttributeMediator.this.log(e);
                }
            }
        });
        return attributeGroup[0];
    }

    protected AttributeGroup createAttributeGroup(Document document) {
        AttributeGroup attributeGroup = new AttributeGroup();
        attributeGroup.setId(Long.parseLong(document.get("atg_id")));
        attributeGroup.setName(document.get("atg_name"));
        attributeGroup.setCode(document.get("atg_code"));
        attributeGroup.setDescription(document.get("atg_description"));
        attributeGroup.setDefaultSelected(Boolean.parseBoolean(document.get("atg_default_selected")));
        attributeGroup.setLinkoutLabel(document.get("atg_linkout_label"));
        attributeGroup.setLinkoutUrl(document.get("atg_linkout_url"));
        attributeGroup.setPublicationName(document.get("atg_publication_name"));
        attributeGroup.setPublicationUrl(document.get("atg_publication_url"));
        return attributeGroup;
    }
}

