/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.LazyLoader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneData;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.Interaction;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Node;
import org.genemania.domain.Ontology;
import org.genemania.domain.OntologyCategory;
import org.genemania.domain.Organism;
import org.genemania.domain.Statistics;
import org.genemania.domain.Tag;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.DefaultTokenStream;

public class LuceneMediator {
    private static final String DEFAULT_FIELD = "all";
    protected Searcher searcher;
    protected Analyzer analyzer;
    public static final String NODE_ID = "node_id";
    public static final String NODE_NAME = "node_name";
    public static final String NODE_GENEDATA_ID = "node_genedata_id";
    public static final String NODE_ORGANISM_ID = "node_organism_id";
    public static final String GENE_ID = "gene_id";
    public static final String GENE_NODE_ID = "node";
    public static final String GENE_ORGANISM_ID = "gene_organism_id";
    public static final String GENE_SYMBOL = "gene";
    public static final String GENE_NAMINGSOURCE_ID = "gene_namingsource_id";
    public static final String GENE_DEFAULT_SELECTED = "gene_selected";
    public static final String GROUP_ID = "group_id";
    public static final String GROUP_ORGANISM_ID = "group_organism_id";
    public static final String GROUP_NAME = "group_name";
    public static final String GROUP_CODE = "group_code";
    public static final String GROUP_DESCRIPTION = "group_description";
    public static final String GROUP_COLOUR = "group_colour";
    public static final String GENEDATA_ID = "genedata_id";
    public static final String GENEDATA_DESCRIPTION = "genedata_desc";
    public static final String GENEDATA_EXTERNAL_ID = "genedata_external_id";
    public static final String GENEDATA_NAMINGSOURCE_ID = "genedata_namingsource_id";
    public static final String NAMINGSOURCE_ID = "namingsource_id";
    public static final String NAMINGSOURCE_NAME = "namingsource_name";
    public static final String NAMINGSOURCE_RANK = "namingsource_rank";
    public static final String NAMINGSOURCE_SHORT_NAME = "namingsource_short_name";
    public static final String ORGANISM_ID = "organism_id";
    public static final String ORGANISM_NAME = "organism_name";
    public static final String ORGANISM_DESCRIPTION = "organism_desc";
    public static final String ORGANISM_ALIAS = "organism_alias";
    public static final String ORGANISM_ONTOLOGY_ID = "organism_o_id";
    public static final String ORGANISM_TAXONOMY_ID = "organism_tax_id";
    public static final String NETWORK_ID = "network_id";
    public static final String NETWORK_GROUP_ID = "network_group_id";
    public static final String NETWORK_NAME = "network_name";
    public static final String NETWORK_DESCRIPTION = "network_desc";
    public static final String NETWORK_DEFAULT_SELECTED = "network_selected";
    public static final String NETWORK_METADATA_ID = "network_metadata_id";
    public static final String NETWORKMETADATA_ID = "metadata_id";
    public static final String NETWORKMETADATA_SOURCE = "metadata_source";
    public static final String NETWORKMETADATA_REFERENCE = "metadata_reference";
    public static final String NETWORKMETADATA_PUBMED_ID = "metadata_pubmed_id";
    public static final String NETWORKMETADATA_AUTHORS = "metadata_authors";
    public static final String NETWORKMETADATA_PUBLICATION_NAME = "metadata_publication";
    public static final String NETWORKMETADATA_YEAR_PUBLISHED = "metadata_year";
    public static final String NETWORKMETADATA_PROCESSING_DESC = "metadata_processing";
    public static final String NETWORKMETADATA_NETWORK_TYPE = "metadata_network";
    public static final String NETWORKMETADATA_ALIAS = "metadata_alias";
    public static final String NETWORKMETADATA_INTERACTION_COUNT = "metadata_interactions";
    public static final String NETWORKMETADATA_DYNAMIC_RANGE = "metadata_dynamic_range";
    public static final String NETWORKMETADATA_EDGE_WEIGHT_DIST = "metadata_edge_weight_dist";
    public static final String NETWORKMETADATA_ACCESS_STATS = "metadata_access_stats";
    public static final String NETWORKMETADATA_COMMENT = "metadata_comment";
    public static final String NETWORKMETADATA_OTHER = "metadata_other";
    public static final String NETWORKMETADATA_TITLE = "metadata_title";
    public static final String NETWORKMETADATA_URL = "metadata_url";
    public static final String NETWORKMETADATA_SOURCE_URL = "metadata_source_url";
    public static final String TAG_ID = "tag_id";
    public static final String TAG_NAME = "tag_name";
    public static final String NETWORKTAGASSOC_ID = "nta_id";
    public static final String NETWORKTAGASSOC_NETWORK_ID = "nta_network_id";
    public static final String NETWORKTAGASSOC_TAG_ID = "nta_tag_id";
    public static final String TYPE = "type";
    public static final String ORGANISM = "organism";
    public static final String GROUP = "group";
    public static final String NETWORK = "network";
    public static final String NODE = "node";
    public static final String GENE = "gene";
    public static final String NAMINGSOURCE = "namingsource";
    public static final String GENEDATA = "genedata";
    public static final String NETWORKMETADATA = "metadata";
    public static final String TAG = "tag";
    public static final String NETWORKTAGASSOC = "nta";
    public static final String ONTOLOGY = "ontology";
    public static final String ONTOLOGYCATEGORY = "ontologycategory";
    public static final String STATISTICS = "statistics";
    public static final String ATTRIBUTEGROUP = "attributegroup";
    public static final String ATTRIBUTE = "attribute";
    public static final String ONTOLOGY_ID = "o_id";
    public static final String ONTOLOGY_NAME = "o_name";
    public static final String ONTOLOGYCATEGORY_ID = "oc_id";
    public static final String ONTOLOGYCATEGORY_ONTOLOGY_ID = "oc_o_id";
    public static final String ONTOLOGYCATEGORY_NAME = "oc_name";
    public static final String ONTOLOGYCATEGORY_DESCRIPTION = "oc_description";
    public static final String STATISTICS_BUILD_DATE = "stats_build_date";
    public static final String ATTRIBUTEGROUP_ID = "atg_id";
    public static final String ATTRIBUTEGROUP_ORGANISM_ID = "atg_organism_id";
    public static final String ATTRIBUTEGROUP_NAME = "atg_name";
    public static final String ATTRIBUTEGROUP_CODE = "atg_code";
    public static final String ATTRIBUTEGROUP_DESCRIPTION = "atg_description";
    public static final String ATTRIBUTEGROUP_LINKOUT_LABEL = "atg_linkout_label";
    public static final String ATTRIBUTEGROUP_LINKOUT_URL = "atg_linkout_url";
    public static final String ATTRIBUTEGROUP_DEFAULT_SELECTED = "atg_default_selected";
    public static final String ATTRIBUTEGROUP_PUBLICATION_NAME = "atg_publication_name";
    public static final String ATTRIBUTEGROUP_PUBLICATION_URL = "atg_publication_url";
    public static final String ATTRIBUTE_ID = "at_id";
    public static final String ATTRIBUTE_ORGANISM_ID = "at_organism_id";
    public static final String ATTRIBUTE_GROUP_ID = "at_atg_id";
    public static final String ATTRIBUTE_EXTERNAL_ID = "at_external_id";
    public static final String ATTRIBUTE_NAME = "at_name";
    public static final String ATTRIBUTE_DESCRIPTION = "at_description";

    public LuceneMediator(Searcher searcher, Analyzer analyzer) {
        this.searcher = searcher;
        this.analyzer = analyzer;
    }

    protected void search(String queryString, Collector results) {
        QueryParser parser = new QueryParser(Version.LUCENE_29, DEFAULT_FIELD, this.analyzer);
        try {
            Query query = parser.parse(queryString);
            this.searcher.search(query, results);
        }
        catch (ParseException e) {
            this.log(e);
        }
        catch (IOException e) {
            this.log(e);
        }
    }

    protected TopDocs search(String queryString, int limit) {
        QueryParser parser = new QueryParser(Version.LUCENE_29, DEFAULT_FIELD, this.analyzer);
        try {
            Query query = parser.parse(queryString);
            return this.searcher.search(query, limit);
        }
        catch (ParseException e) {
            this.log(e);
        }
        catch (IOException e) {
            this.log(e);
        }
        return null;
    }

    protected void log(Throwable t) {
        t.printStackTrace();
    }

    protected Node createNode(long id, final long organismId) {
        final Node[] result = new Node[1];
        this.search(String.format("+%s:\"%d\" +%s:\"%d\"", NODE_ID, id, NODE_ORGANISM_ID, organismId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createNode(document, organismId);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected Node createNode(final Document document, final long organismId) {
        final Node node = new Node();
        final long nodeId = Long.parseLong(document.get(NODE_ID));
        node.setId(nodeId);
        node.setName(document.get(NODE_NAME));
        node.setGeneData((GeneData)Enhancer.create(GeneData.class, (Callback)new LazyLoader(){

            public Object loadObject() throws Exception {
                return LuceneMediator.this.createGeneData(Long.parseLong(document.get(LuceneMediator.NODE_GENEDATA_ID)));
            }
        }));
        node.setGenes((Collection)Enhancer.create(Collection.class, (Callback)new LazyLoader(){

            public Object loadObject() throws Exception {
                BooleanQuery query = new BooleanQuery();
                query.add((Query)new TermQuery(new Term(LuceneMediator.GENE_ORGANISM_ID, String.valueOf(organismId))), BooleanClause.Occur.MUST);
                query.add((Query)new TermQuery(new Term("node", String.valueOf(nodeId))), BooleanClause.Occur.MUST);
                return LuceneMediator.this.createGenes((Query)query, node, null);
            }
        }));
        return node;
    }

    protected GeneData createGeneData(long id) {
        final GeneData[] result = new GeneData[1];
        this.search(String.format("%s:\"%d\"", GENEDATA_ID, id), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createGeneData(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected GeneData createGeneData(Document document) {
        GeneData data = new GeneData();
        data.setId(Long.parseLong(document.get(GENEDATA_ID)));
        data.setDescription(document.get(GENEDATA_DESCRIPTION));
        data.setExternalId(document.get(GENEDATA_EXTERNAL_ID));
        final String namingSourceId = document.get(GENEDATA_NAMINGSOURCE_ID);
        if (namingSourceId != null) {
            data.setLinkoutSource((GeneNamingSource)Enhancer.create(GeneNamingSource.class, (Callback)new LazyLoader(){

                public Object loadObject() throws Exception {
                    return LuceneMediator.this.createNamingSource(Long.parseLong(namingSourceId));
                }
            }));
        }
        return data;
    }

    private GeneNamingSource createNamingSource(long id) {
        final GeneNamingSource[] result = new GeneNamingSource[1];
        this.search(String.format("%s:\"%d\"", NAMINGSOURCE_ID, id), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createNamingSource(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected GeneNamingSource createNamingSource(Document document) {
        GeneNamingSource source = new GeneNamingSource();
        source.setId(Long.parseLong(document.get(NAMINGSOURCE_ID)));
        source.setName(document.get(NAMINGSOURCE_NAME));
        source.setRank(Byte.parseByte(document.get(NAMINGSOURCE_RANK)));
        String namingSource = document.get(NAMINGSOURCE_SHORT_NAME);
        if (namingSource == null) {
            namingSource = "";
        }
        source.setShortName(namingSource);
        return source;
    }

    protected GeneNamingSource createNamingSource(String namingSourceName) {
        final GeneNamingSource[] result = new GeneNamingSource[1];
        this.search(String.format("%s:\"%s\"", NAMINGSOURCE_NAME, QueryParser.escape((String)namingSourceName)), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createNamingSource(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected Gene createGene(long organismId, String geneSymbol) {
        final Gene[] result = new Gene[1];
        this.search(String.format("+%s:\"%d\" +%s:\"%s\"", GENE_ORGANISM_ID, organismId, "gene", QueryParser.escape((String)geneSymbol)), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createGene(document, null, null, null);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected Gene createGene(String geneSymbol) {
        final Gene[] result = new Gene[1];
        this.search(String.format("%s:\"%s\"", "gene", QueryParser.escape((String)geneSymbol)), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createGene(document, null, null, null);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected Gene createGene(final Document document, Node node, Organism organism, GeneNamingSource namingSource) {
        if (node == null) {
            node = (Node)Enhancer.create(Node.class, (Callback)new LazyLoader(){

                public Object loadObject() throws Exception {
                    long nodeId = Long.parseLong(document.get("node"));
                    long organismId = Long.parseLong(document.get(LuceneMediator.GENE_ORGANISM_ID));
                    return LuceneMediator.this.createNode(nodeId, organismId);
                }
            });
        }
        if (organism == null) {
            organism = (Organism)Enhancer.create(Organism.class, (Callback)new LazyLoader(){

                public Object loadObject() throws Exception {
                    return LuceneMediator.this.createOrganism(Long.parseLong(document.get(LuceneMediator.GENE_ORGANISM_ID)));
                }
            });
        }
        if (namingSource == null) {
            final long namingSourceId = Long.parseLong(document.get(GENE_NAMINGSOURCE_ID));
            namingSource = (GeneNamingSource)Enhancer.create(GeneNamingSource.class, (Callback)new LazyLoader(){

                public Object loadObject() throws Exception {
                    return LuceneMediator.this.createNamingSource(namingSourceId);
                }
            });
        }
        Gene gene = new Gene();
        gene.setId(Long.parseLong(document.get(GENE_ID)));
        gene.setSymbol(document.get("gene"));
        gene.setNode(node);
        gene.setOrganism(organism);
        gene.setNamingSource(namingSource);
        gene.setDefaultSelected(Boolean.parseBoolean(document.get(GENE_DEFAULT_SELECTED)));
        return gene;
    }

    protected Organism createOrganism(long organismId) {
        final Organism[] result = new Organism[1];
        this.search(String.format("%s:\"%d\"", ORGANISM_ID, organismId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createOrganism(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected Organism createOrganism(Document document) {
        final long organismId = Long.parseLong(document.get(ORGANISM_ID));
        Organism organism = new Organism();
        organism.setId(organismId);
        organism.setName(document.get(ORGANISM_NAME));
        organism.setDescription(document.get(ORGANISM_DESCRIPTION));
        organism.setInteractionNetworkGroups((Collection)Enhancer.create(Collection.class, (Callback)new LazyLoader(){

            public Object loadObject() throws Exception {
                return LuceneMediator.this.createNetworkGroups(organismId);
            }
        }));
        organism.setAlias(document.get(ORGANISM_ALIAS));
        final long ontologyId = Long.parseLong(document.get(ORGANISM_ONTOLOGY_ID));
        if (ontologyId != -1L) {
            organism.setOntology((Ontology)Enhancer.create(Ontology.class, (Callback)new LazyLoader(){

                public Object loadObject() throws Exception {
                    return LuceneMediator.this.createOntology(ontologyId);
                }
            }));
        }
        organism.setTaxonomyId(Long.parseLong(document.get(ORGANISM_TAXONOMY_ID)));
        organism.setDefaultGenes((Collection)Enhancer.create(Collection.class, (Callback)new LazyLoader(){

            public Object loadObject() throws Exception {
                return LuceneMediator.this.createDefaultSelectedGenes(organismId);
            }
        }));
        return organism;
    }

    protected Ontology createOntology(long ontologyId) {
        final Ontology[] result = new Ontology[1];
        this.search(String.format("%s:\"%d\"", ONTOLOGY_ID, ontologyId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createOntology(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected Ontology createOntology(Document document) {
        Ontology ontology = new Ontology();
        final long ontologyId = Long.parseLong(document.get(ONTOLOGY_ID));
        ontology.setId(ontologyId);
        ontology.setName(document.get(ONTOLOGY_NAME));
        ontology.setCategories((Collection)Enhancer.create(Collection.class, (Callback)new LazyLoader(){

            public Object loadObject() throws Exception {
                return LuceneMediator.this.createOntologyCategories(ontologyId);
            }
        }));
        return ontology;
    }

    private OntologyCategory createOntologyCategory(Document document) {
        OntologyCategory category = new OntologyCategory();
        category.setId(Long.parseLong(document.get(ONTOLOGYCATEGORY_ID)));
        category.setName(document.get(ONTOLOGYCATEGORY_NAME));
        category.setDescription(document.get(ONTOLOGYCATEGORY_DESCRIPTION));
        return category;
    }

    protected Collection<OntologyCategory> createOntologyCategories(long ontologyId) {
        final HashSet<OntologyCategory> result = new HashSet<OntologyCategory>();
        this.search(String.format("%s:\"%d\"", ONTOLOGYCATEGORY_ONTOLOGY_ID, ontologyId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    final Document document = LuceneMediator.this.searcher.doc(doc);
                    result.add((OntologyCategory)Enhancer.create(OntologyCategory.class, (Callback)new LazyLoader(){

                        public Object loadObject() throws Exception {
                            return LuceneMediator.this.createOntologyCategory(document);
                        }
                    }));
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result;
    }

    protected OntologyCategory createOntologyCategory(long categoryId) {
        final OntologyCategory[] result = new OntologyCategory[1];
        this.search(String.format("%s:\"%d\"", ONTOLOGYCATEGORY_ID, categoryId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    final Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = (OntologyCategory)Enhancer.create(OntologyCategory.class, (Callback)new LazyLoader(){

                        public Object loadObject() throws Exception {
                            return LuceneMediator.this.createOntologyCategory(document);
                        }
                    });
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected OntologyCategory createOntologyCategory(String name) {
        final OntologyCategory[] result = new OntologyCategory[1];
        TermQuery query = new TermQuery(new Term(ONTOLOGYCATEGORY_NAME, name));
        try {
            this.searcher.search((Query)query, (Collector)new AbstractCollector(){

                @Override
                public void handleHit(int doc) {
                    try {
                        final Document document = LuceneMediator.this.searcher.doc(doc);
                        result[0] = (OntologyCategory)Enhancer.create(OntologyCategory.class, (Callback)new LazyLoader(){

                            public Object loadObject() throws Exception {
                                return LuceneMediator.this.createOntologyCategory(document);
                            }
                        });
                    }
                    catch (CorruptIndexException e) {
                        LuceneMediator.this.log(e);
                    }
                    catch (IOException e) {
                        LuceneMediator.this.log(e);
                    }
                }
            });
        }
        catch (IOException e) {
            this.log(e);
        }
        return result[0];
    }

    protected Collection<InteractionNetworkGroup> createNetworkGroups(long organismId) {
        final HashSet<InteractionNetworkGroup> result = new HashSet<InteractionNetworkGroup>();
        this.search(String.format("%s:\"%d\"", GROUP_ORGANISM_ID, organismId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    final Document document = LuceneMediator.this.searcher.doc(doc);
                    result.add((InteractionNetworkGroup)Enhancer.create(InteractionNetworkGroup.class, (Callback)new LazyLoader(){

                        public Object loadObject() throws Exception {
                            return LuceneMediator.this.createNetworkGroup(document);
                        }
                    }));
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result;
    }

    public InteractionNetworkGroup createNetworkGroup(Document document) {
        final long groupId = Long.parseLong(document.get(GROUP_ID));
        InteractionNetworkGroup group = new InteractionNetworkGroup();
        group.setId(groupId);
        group.setName(document.get(GROUP_NAME));
        String code = document.get(GROUP_CODE);
        if (code == null) {
            code = document.get(GROUP_DESCRIPTION);
        }
        group.setCode(code);
        group.setDescription(document.get(GROUP_DESCRIPTION));
        group.setInteractionNetworks((Collection)Enhancer.create(Collection.class, (Callback)new LazyLoader(){

            public Object loadObject() throws Exception {
                return LuceneMediator.this.createNetworks(groupId);
            }
        }));
        return group;
    }

    protected List<Gene> createGenes(long organismId, List<String> geneSymbols) {
        BooleanQuery query = new BooleanQuery();
        try {
            for (String symbol : geneSymbols) {
                PhraseQuery phrase = this.createPhraseQuery("gene", symbol);
                query.add((Query)phrase, BooleanClause.Occur.SHOULD);
            }
            BooleanQuery query2 = new BooleanQuery();
            query2.add((Query)query, BooleanClause.Occur.MUST);
            query2.add((Query)new TermQuery(new Term(GENE_ORGANISM_ID, String.valueOf(organismId))), BooleanClause.Occur.MUST);
            return this.createGenes((Query)query2, null, this.createOrganism(organismId));
        }
        catch (IOException e) {
            this.log(e);
            return Collections.emptyList();
        }
    }

    protected List<Gene> createGenes(long organismId) {
        TermQuery query = new TermQuery(new Term(GENE_ORGANISM_ID, String.valueOf(organismId)));
        return this.createGenes((Query)query, null, this.createOrganism(organismId));
    }

    private Object createDefaultSelectedGenes(long organismId) {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(GENE_ORGANISM_ID, String.valueOf(organismId))), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term(GENE_DEFAULT_SELECTED, String.valueOf(true))), BooleanClause.Occur.MUST);
        return this.createGenes((Query)query, null, this.createOrganism(organismId));
    }

    protected List<Gene> createGenes(Query query, final Node node, final Organism organism) {
        final ArrayList<Gene> result = new ArrayList<Gene>();
        try {
            this.searcher.search(query, (Collector)new AbstractCollector(){

                @Override
                public void handleHit(final int doc) {
                    result.add((Gene)Enhancer.create(Gene.class, (Callback)new LazyLoader(){

                        public Object loadObject() throws Exception {
                            return LuceneMediator.this.createGene(LuceneMediator.this.searcher.doc(doc), node, organism, null);
                        }
                    }));
                }
            });
        }
        catch (IOException e) {
            this.log(e);
        }
        return result;
    }

    protected PhraseQuery createPhraseQuery(String field, String phrase) throws IOException {
        TokenStream stream = this.analyze(phrase);
        stream.reset();
        PhraseQuery query = new PhraseQuery();
        while (stream.incrementToken()) {
            TermAttribute term = (TermAttribute)stream.getAttribute(TermAttribute.class);
            query.add(new Term(field, term.term()));
        }
        stream.end();
        stream.close();
        return query;
    }

    protected TokenStream analyze(String text) throws IOException {
        return this.analyzer.reusableTokenStream(DEFAULT_FIELD, (Reader)new StringReader(text));
    }

    protected List<InteractionNetwork> createNetworks(Long groupId) {
        final ArrayList<InteractionNetwork> result = new ArrayList<InteractionNetwork>();
        this.search(String.format("%s:\"%d\"", NETWORK_GROUP_ID, groupId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    final Document document = LuceneMediator.this.searcher.doc(doc);
                    result.add((InteractionNetwork)Enhancer.create(InteractionNetwork.class, (Callback)new LazyLoader(){

                        public Object loadObject() throws Exception {
                            return LuceneMediator.this.createNetwork(document);
                        }
                    }));
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result;
    }

    protected InteractionNetwork createNetwork(Document document) {
        InteractionNetwork network = new InteractionNetwork();
        long networkId = Long.parseLong(document.get(NETWORK_ID));
        network.setId(networkId);
        network.setName(document.get(NETWORK_NAME));
        network.setDescription(document.get(NETWORK_DESCRIPTION));
        Set<Interaction> interactions = Collections.emptySet();
        network.setInteractions(interactions);
        network.setMetadata(this.createNetworkMetadata(Long.parseLong(document.get(NETWORK_METADATA_ID))));
        network.setTags(this.createTags(networkId));
        network.setDefaultSelected(Boolean.parseBoolean(document.get(NETWORK_DEFAULT_SELECTED)));
        return network;
    }

    private Collection<Tag> createTags(long networkId) {
        final ArrayList<Tag> tags = new ArrayList<Tag>();
        this.search(String.format("%s:\"%d\"", NETWORKTAGASSOC_NETWORK_ID, networkId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    long tagId = Long.parseLong(document.get(LuceneMediator.NETWORKTAGASSOC_TAG_ID));
                    tags.add(LuceneMediator.this.createTag(tagId));
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return tags;
    }

    protected Tag createTag(long tagId) {
        final Tag[] result = new Tag[1];
        this.search(String.format("%s:\"%d\"", TAG_ID, tagId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createTag(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected Tag createTag(Document document) {
        Tag tag = new Tag();
        tag.setId(Long.parseLong(document.get(TAG_ID)));
        tag.setName(document.get(TAG_NAME));
        return tag;
    }

    protected NetworkMetadata createNetworkMetadata(long metadataId) {
        final NetworkMetadata[] result = new NetworkMetadata[1];
        this.search(String.format("%s:\"%d\"", NETWORKMETADATA_ID, metadataId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createNetworkMetadata(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected NetworkMetadata createNetworkMetadata(Document document) {
        NetworkMetadata data = new NetworkMetadata();
        data.setId(Long.parseLong(document.get(NETWORKMETADATA_ID)));
        data.setSource(document.get(NETWORKMETADATA_SOURCE));
        data.setReference(document.get(NETWORKMETADATA_REFERENCE));
        data.setPubmedId(document.get(NETWORKMETADATA_PUBMED_ID));
        data.setAuthors(document.get(NETWORKMETADATA_AUTHORS));
        data.setPublicationName(document.get(NETWORKMETADATA_PUBLICATION_NAME));
        data.setYearPublished(document.get(NETWORKMETADATA_YEAR_PUBLISHED));
        data.setProcessingDescription(document.get(NETWORKMETADATA_PROCESSING_DESC));
        data.setNetworkType(document.get(NETWORKMETADATA_NETWORK_TYPE));
        data.setAlias(document.get(NETWORKMETADATA_ALIAS));
        data.setInteractionCount(Long.parseLong(document.get(NETWORKMETADATA_INTERACTION_COUNT)));
        data.setDynamicRange(document.get(NETWORKMETADATA_DYNAMIC_RANGE));
        data.setEdgeWeightDistribution(document.get(NETWORKMETADATA_EDGE_WEIGHT_DIST));
        data.setAccessStats(Long.parseLong(document.get(NETWORKMETADATA_ACCESS_STATS)));
        data.setComment(document.get(NETWORKMETADATA_COMMENT));
        data.setOther(document.get(NETWORKMETADATA_OTHER));
        data.setTitle(document.get(NETWORKMETADATA_TITLE));
        data.setUrl(document.get(NETWORKMETADATA_URL));
        data.setSourceUrl(document.get(NETWORKMETADATA_SOURCE_URL));
        return data;
    }

    protected InteractionNetwork createNetwork(long networkId) {
        final InteractionNetwork[] result = new InteractionNetwork[1];
        this.search(String.format("%s:\"%d\"", NETWORK_ID, networkId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createNetwork(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected InteractionNetworkGroup createNetworkGroup(long organismId, String groupName) {
        final InteractionNetworkGroup[] result = new InteractionNetworkGroup[1];
        this.search(String.format("+%s:\"%d\" +%s:\"%s\"", GROUP_ORGANISM_ID, organismId, GROUP_NAME, QueryParser.escape((String)groupName)), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createNetworkGroup(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected InteractionNetworkGroup createNetworkGroup(long groupId) {
        final InteractionNetworkGroup[] result = new InteractionNetworkGroup[1];
        this.search(String.format("+%s:\"%d\"", GROUP_ID, groupId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    result[0] = LuceneMediator.this.createNetworkGroup(document);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    protected Statistics createStatistics() {
        final Date[] date = new Date[1];
        this.search(String.format("%s:%s", TYPE, STATISTICS), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    String dateString = document.get(LuceneMediator.STATISTICS_BUILD_DATE);
                    date[0] = DateTools.stringToDate((String)dateString);
                }
                catch (CorruptIndexException e) {
                    LuceneMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
                catch (java.text.ParseException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        if (date[0] == null) {
            date[0] = new Date();
        }
        Statistics statistics = new Statistics();
        statistics.setDate(date[0]);
        statistics.setGenes(this.count("type:node"));
        statistics.setNetworks(this.count("type:network"));
        statistics.setOrganisms(this.count("type:organism"));
        statistics.setInteractions(this.sum(String.format("%s:%s", TYPE, NETWORKMETADATA), NETWORKMETADATA_INTERACTION_COUNT));
        return statistics;
    }

    private long count(String query) {
        final Long[] result = new Long[]{0L};
        this.search(query, new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                result[0] = result[0] + 1L;
            }
        });
        return result[0];
    }

    private long sum(String query, final String field) {
        final Long[] result = new Long[]{0L};
        this.search(query, new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneMediator.this.searcher.doc(doc);
                    String value = document.get(field);
                    if (value != null) {
                        result[0] = result[0] + Long.parseLong(value);
                    }
                }
                catch (IOException e) {
                    LuceneMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    public static final Analyzer createDefaultAnalyzer() {
        return new Analyzer(){

            public TokenStream tokenStream(String field, Reader reader) {
                return new LowerCaseFilter((TokenStream)new DefaultTokenStream(reader));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean indexExists(File path) {
        boolean bl;
        FSDirectory directory = FSDirectory.open((File)path);
        try {
            bl = IndexReader.indexExists((Directory)directory);
        }
        catch (Throwable throwable) {
            try {
                directory.close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        directory.close();
        return bl;
    }
}

