/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Searcher;
import org.genemania.domain.GeneNamingSource;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.LuceneMediator;

public class LuceneNamingSourceMediator
extends LuceneMediator {
    public LuceneNamingSourceMediator(Searcher searcher, Analyzer analyzer) {
        super(searcher, analyzer);
    }

    public List<GeneNamingSource> getAllNamingSources() {
        final ArrayList<GeneNamingSource> result = new ArrayList<GeneNamingSource>();
        this.search(String.format("%s:%s", "type", "namingsource"), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    result.add(LuceneNamingSourceMediator.this.createNamingSource(LuceneNamingSourceMediator.this.searcher.doc(doc)));
                }
                catch (IOException e) {
                    LuceneNamingSourceMediator.this.log(e);
                }
            }
        });
        Collections.sort(result, new Comparator<GeneNamingSource>(){

            @Override
            public int compare(GeneNamingSource source1, GeneNamingSource source2) {
                return source2.getRank() - source1.getRank();
            }
        });
        return result;
    }
}

