/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.LazyLoader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.Searcher;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.mediator.InteractionCursor;
import org.genemania.mediator.NetworkMediator;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.LuceneMediator;

public class LuceneNetworkMediator
extends LuceneMediator
implements NetworkMediator {
    public LuceneNetworkMediator(Searcher searcher, Analyzer analyzer) {
        super(searcher, analyzer);
    }

    @Override
    public InteractionCursor createInteractionCursor(long networkId) {
        return null;
    }

    @Override
    public List<InteractionNetwork> getAllNetworks() {
        final ArrayList<InteractionNetwork> result = new ArrayList<InteractionNetwork>();
        this.search(String.format("%s:\"%s\"", "type", "network"), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    final Document document = LuceneNetworkMediator.this.searcher.doc(doc);
                    result.add((InteractionNetwork)Enhancer.create(InteractionNetwork.class, (Callback)new LazyLoader(){

                        public Object loadObject() throws Exception {
                            return LuceneNetworkMediator.this.createNetwork(document);
                        }
                    }));
                }
                catch (CorruptIndexException e) {
                    LuceneNetworkMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneNetworkMediator.this.log(e);
                }
            }
        });
        return result;
    }

    @Override
    public InteractionNetwork getNetwork(long networkId) {
        return this.createNetwork(networkId);
    }

    @Override
    public InteractionNetworkGroup getNetworkGroupByName(String groupName, long organismId) {
        return this.createNetworkGroup(organismId, groupName);
    }

    @Override
    public void saveNetwork(InteractionNetwork network) {
    }

    @Override
    public void saveNetworkGroup(InteractionNetworkGroup group) {
    }

    @Override
    public List<InteractionNetworkGroup> getNetworkGroupsByOrganism(long organismId) {
        ArrayList<InteractionNetworkGroup> groups = new ArrayList<InteractionNetworkGroup>(this.createNetworkGroups(organismId));
        return groups;
    }

    @Override
    public InteractionNetworkGroup getNetworkGroupForNetwork(long networkId) {
        final InteractionNetworkGroup[] result = new InteractionNetworkGroup[1];
        this.search(String.format("+%s:\"%d\"", "network_id", networkId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneNetworkMediator.this.searcher.doc(doc);
                    Long groupId = Long.parseLong(document.get("network_group_id"));
                    result[0] = LuceneNetworkMediator.this.createNetworkGroup(groupId);
                }
                catch (CorruptIndexException e) {
                    LuceneNetworkMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneNetworkMediator.this.log(e);
                }
            }
        });
        return result[0];
    }

    @Override
    public boolean isValidNetwork(long organismId, long networkId) {
        final Long[] groupId = new Long[1];
        this.search(String.format("+%s:\"%d\"", "network_id", networkId), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneNetworkMediator.this.searcher.doc(doc);
                    groupId[0] = Long.parseLong(document.get("network_group_id"));
                }
                catch (CorruptIndexException e) {
                    LuceneNetworkMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneNetworkMediator.this.log(e);
                }
            }
        });
        if (groupId[0] == null) {
            return false;
        }
        final Long[] organism = new Long[1];
        this.search(String.format("+%s:\"%d\"", "group_id", groupId[0]), new AbstractCollector(){

            @Override
            public void handleHit(int doc) {
                try {
                    Document document = LuceneNetworkMediator.this.searcher.doc(doc);
                    organism[0] = Long.parseLong(document.get("group_organism_id"));
                }
                catch (CorruptIndexException e) {
                    LuceneNetworkMediator.this.log(e);
                }
                catch (IOException e) {
                    LuceneNetworkMediator.this.log(e);
                }
            }
        });
        if (organism[0] == null) {
            return false;
        }
        return organism[0].equals(organismId);
    }
}

