/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene.exporter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.mediator.lucene.LuceneMediator;
import org.genemania.mediator.lucene.LuceneOrganismMediator;
import org.genemania.mediator.lucene.exporter.ExportProfile;

public class CoreExportProfile
implements ExportProfile {
    private Set<Long> includedNetworks;

    public CoreExportProfile(String basePath) throws IOException {
        String indexPath = String.format("%s%s%s", basePath, File.separator, "lucene_index");
        Searcher searcher = this.createSearcher(indexPath);
        LuceneOrganismMediator mediator = new LuceneOrganismMediator(searcher, LuceneMediator.createDefaultAnalyzer());
        this.includedNetworks = new HashSet<Long>();
        for (Organism organism : mediator.getAllOrganisms()) {
            for (InteractionNetworkGroup group : organism.getInteractionNetworkGroups()) {
                for (InteractionNetwork network : group.getInteractionNetworks()) {
                    if (!network.isDefaultSelected()) continue;
                    this.includedNetworks.add(network.getId());
                }
            }
        }
        searcher.close();
    }

    Searcher createSearcher(String indexPath) throws IOException {
        ArrayList<IndexSearcher> searchers = new ArrayList<IndexSearcher>();
        File indices = new File(indexPath);
        for (File file : indices.listFiles()) {
            if (!LuceneMediator.indexExists(file)) continue;
            FSDirectory directory = FSDirectory.open((File)file);
            searchers.add(new IndexSearcher((Directory)directory));
        }
        if (searchers.size() == 0) {
            Directory directory = this.createEmptyIndex();
            searchers.add(new IndexSearcher(directory));
        }
        return new MultiSearcher(searchers.toArray(new Searchable[searchers.size()]));
    }

    private Directory createEmptyIndex() {
        RAMDirectory directory = new RAMDirectory();
        try {
            IndexWriter writer = new IndexWriter((Directory)directory, (Analyzer)new StandardAnalyzer(Version.LUCENE_29), true, IndexWriter.MaxFieldLength.UNLIMITED);
            writer.commit();
            writer.close();
        }
        catch (CorruptIndexException e) {
        }
        catch (LockObtainFailedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return directory;
    }

    @Override
    public boolean includesNetwork(String[] networkData) {
        long networkId = Long.parseLong(networkData[0]);
        return this.includedNetworks.contains(networkId);
    }
}

