/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene.exporter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.genemania.configobj.ConfigObj;
import org.genemania.configobj.Section;
import org.genemania.domain.Organism;
import org.genemania.mediator.lucene.LuceneMediator;
import org.genemania.mediator.lucene.exporter.CoreExportProfile;
import org.genemania.mediator.lucene.exporter.CustomExportProfile;
import org.genemania.mediator.lucene.exporter.DefaultExportProfile;
import org.genemania.mediator.lucene.exporter.ExportProfile;

public class Generic2LuceneExporter {
    public static final int NETWORK_ID = 0;
    public static final int NETWORK_NAME = 1;
    public static final int NETWORK_METADATA_ID = 2;
    public static final int NETWORK_DESCRIPTION = 3;
    public static final int NETWORK_DEFAULT_SELECTED = 4;
    public static final int NETWORK_GROUP_ID = 5;
    private Map<String, String> networkGroupColours = Collections.emptyMap();
    private String genericDbPath;
    private String indexPath;
    private String basePath;
    private String profileName;
    private ConfigObj config;

    public void close() {
    }

    static String join(String connector, String[] items) {
        StringBuilder builder = new StringBuilder();
        for (String item : items) {
            if (builder.length() > 0) {
                builder.append(connector);
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Usage:");
            System.out.printf("%s <db-config.cfg> <raw-data-path> <colours.txt> [<profile>]\n", Generic2LuceneExporter.class.getName());
            System.out.println();
            return;
        }
        String configurationPath = args[0];
        String basePath = args[1];
        String colourConfigPath = args[2];
        String profileName = args.length == 4 ? args[3] : null;
        Map<String, String> colours = Generic2LuceneExporter.loadColours(colourConfigPath);
        ConfigObj config = new ConfigObj(new FileReader(configurationPath));
        String genericDbPath = Generic2LuceneExporter.join(File.separator, new String[]{basePath, config.getSection("FileLocations").getEntry("generic_db_dir")});
        Generic2LuceneExporter exporter = new Generic2LuceneExporter();
        exporter.setNetworkGroupColours(colours);
        exporter.setBasePath(basePath);
        exporter.setGenericDbPath(genericDbPath);
        exporter.setProfileName(profileName);
        exporter.setConfig(config);
        exporter.setIndexPath("lucene_index");
        exporter.export();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() throws Exception {
        final ExportProfile profile = Generic2LuceneExporter.createExportProfile(this.basePath, this.profileName);
        Analyzer analyzer = Generic2LuceneExporter.createAnalyzer();
        try {
            String[] organisms;
            final HashMap namingSourceIds = new HashMap();
            File indexFile = new File(this.makeIndexPath("base"));
            FSDirectory directory = FSDirectory.open((File)indexFile);
            final IndexWriter indexWriter = new IndexWriter((Directory)directory, analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
            Generic2LuceneExporter.processFile(this.genericDbPath, "GENE_NAMING_SOURCES.txt", new FileHandler(){

                @Override
                public boolean process(String line) throws IOException {
                    String[] parts = line.split("\t", -1);
                    Generic2LuceneExporter.this.exportNamingSource(indexWriter, parts);
                    namingSourceIds.put(parts[1], Long.parseLong(parts[0]));
                    return true;
                }
            });
            Generic2LuceneExporter.processFile(this.genericDbPath, "TAGS.txt", new FileHandler(){

                @Override
                public boolean process(String line) throws IOException {
                    String[] parts = line.split("\t", -1);
                    Generic2LuceneExporter.this.exportTag(indexWriter, parts);
                    return true;
                }
            });
            Generic2LuceneExporter.processFile(this.genericDbPath, "ONTOLOGIES.txt", new FileHandler(){

                @Override
                public boolean process(String line) throws IOException {
                    String[] parts = line.split("\t", -1);
                    Generic2LuceneExporter.this.exportOntologies(indexWriter, parts);
                    return true;
                }
            });
            Generic2LuceneExporter.processFile(this.genericDbPath, "ONTOLOGY_CATEGORIES.txt", new FileHandler(){

                @Override
                public boolean process(String line) throws IOException {
                    String[] parts = line.split("\t", -1);
                    Generic2LuceneExporter.this.exportOntologyCategories(indexWriter, parts);
                    return true;
                }
            });
            this.exportStatistics(indexWriter);
            indexWriter.close();
            for (String organismId : organisms = this.config.getSection("Organisms").getEntry("organisms").split("\\s*,\\s*")) {
                Section organismSection = this.config.getSection(organismId);
                final String shortName = organismSection.getEntry("short_name");
                System.out.println(shortName);
                RAMDirectory ramDirectory = new RAMDirectory();
                final IndexWriter writer = new IndexWriter((Directory)ramDirectory, analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
                final Organism organism = new Organism();
                Generic2LuceneExporter.processFile(this.genericDbPath, "ORGANISMS.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        if (parts[1].equals(shortName)) {
                            Generic2LuceneExporter.this.exportOrganism(writer, parts);
                            Generic2LuceneExporter.populateOrganism(organism, parts);
                            return false;
                        }
                        return true;
                    }
                });
                final Long entrezNamingSourceId = (Long)namingSourceIds.get("Entrez Gene ID");
                final HashMap externalIds = new HashMap();
                final HashMap externalNamingSourceIds = new HashMap();
                final HashSet nodes = new HashSet();
                Generic2LuceneExporter.processFile(this.genericDbPath, "GENES.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long organismId = Long.parseLong(parts[5]);
                        if (organismId == organism.getId()) {
                            Generic2LuceneExporter.this.exportGene(writer, parts);
                            long nodeId = Long.parseLong(parts[4]);
                            nodes.add(nodeId);
                            long namingSourceId = Long.parseLong(parts[3]);
                            if (namingSourceId == entrezNamingSourceId) {
                                externalIds.put(nodeId, parts[1]);
                                externalNamingSourceIds.put(nodeId, namingSourceId);
                            }
                        }
                        return true;
                    }
                });
                final HashMap geneDataToNodeIds = new HashMap();
                Generic2LuceneExporter.processFile(this.genericDbPath, "NODES.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long nodeId = Long.parseLong(parts[0]);
                        if (nodes.contains(nodeId)) {
                            Generic2LuceneExporter.this.exportNode(writer, parts, String.valueOf(organism.getId()));
                            geneDataToNodeIds.put(Long.parseLong(parts[2]), nodeId);
                        }
                        return true;
                    }
                });
                Generic2LuceneExporter.processFile(this.genericDbPath, "GENE_DATA.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long geneDataId = Long.parseLong(parts[0]);
                        Long nodeId = (Long)geneDataToNodeIds.get(geneDataId);
                        if (nodeId != null) {
                            String externalId = (String)externalIds.get(nodeId);
                            long namingSourceId = -1L;
                            if (externalId != null) {
                                namingSourceId = (Long)externalNamingSourceIds.get(nodeId);
                            }
                            Generic2LuceneExporter.this.exportGeneData(writer, parts, externalId, namingSourceId);
                        }
                        return true;
                    }
                });
                final HashSet groups = new HashSet();
                Generic2LuceneExporter.processFile(this.genericDbPath, "NETWORK_GROUPS.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long organismId = Long.parseLong(parts[4]);
                        if (organismId == organism.getId()) {
                            Generic2LuceneExporter.this.exportGroup(writer, parts);
                            groups.add(Long.parseLong(parts[0]));
                        }
                        return true;
                    }
                });
                final HashSet metadata = new HashSet();
                final HashSet networks = new HashSet();
                Generic2LuceneExporter.processFile(this.genericDbPath, "NETWORKS.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long groupId = Long.parseLong(parts[5]);
                        long networkId = Long.parseLong(parts[0]);
                        if (groups.contains(groupId) && profile.includesNetwork(parts)) {
                            Generic2LuceneExporter.this.exportNetwork(writer, parts);
                            long metadataId = Long.parseLong(parts[2]);
                            metadata.add(metadataId);
                            networks.add(networkId);
                        }
                        return true;
                    }
                });
                Generic2LuceneExporter.processFile(this.genericDbPath, "NETWORK_METADATA.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long metadataId = Long.parseLong(parts[0]);
                        if (metadata.contains(metadataId)) {
                            Generic2LuceneExporter.this.exportNetworkMetadata(writer, parts);
                        }
                        return true;
                    }
                });
                Generic2LuceneExporter.processFile(this.genericDbPath, "NETWORK_TAG_ASSOC.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long networkId = Long.parseLong(parts[1]);
                        if (networks.contains(networkId)) {
                            Generic2LuceneExporter.this.exportNetworkTagAssoc(writer, parts);
                        }
                        return true;
                    }
                });
                final HashSet attribute_groups = new HashSet();
                Generic2LuceneExporter.processFile(this.genericDbPath, "ATTRIBUTE_GROUPS.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long organismId = Long.parseLong(parts[1]);
                        if (organismId == organism.getId()) {
                            Generic2LuceneExporter.this.exportAttributeGroup(writer, parts);
                            long group_id = Long.parseLong(parts[0]);
                            attribute_groups.add(group_id);
                        }
                        return true;
                    }
                });
                final HashSet attributes = new HashSet();
                Generic2LuceneExporter.processFile(this.genericDbPath, "ATTRIBUTES.txt", new FileHandler(){

                    @Override
                    public boolean process(String line) throws IOException {
                        String[] parts = line.split("\t", -1);
                        long group_id = Long.parseLong(parts[1]);
                        if (attribute_groups.contains(group_id)) {
                            Generic2LuceneExporter.this.exportAttribute(writer, parts);
                            long attribute_id = Long.parseLong(parts[0]);
                            attributes.add(attribute_id);
                        }
                        return true;
                    }
                });
                writer.close();
                String gmOrganismId = organismSection.getEntry("gm_organism_id");
                File organismFile = new File(this.makeIndexPath(String.format("%s", gmOrganismId)));
                FSDirectory fileDirectory = FSDirectory.open((File)organismFile);
                IndexWriter organismWriter = new IndexWriter((Directory)fileDirectory, analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
                IndexReader reader = IndexReader.open((Directory)ramDirectory);
                organismWriter.addIndexes(new IndexReader[]{reader});
                organismWriter.close();
                fileDirectory.close();
                ramDirectory.close();
                Properties properties = new Properties();
                properties.put("short_name", shortName);
                properties.put("common_name", organismSection.getEntry("common_name"));
                properties.put("organism_id", gmOrganismId);
                String propertyPath = String.format("%s%smetadata.xml", gmOrganismId, File.separator);
                FileOutputStream out = new FileOutputStream(this.makeIndexPath(propertyPath));
                try {
                    properties.storeToXML((OutputStream)out, null, "UTF-8");
                }
                finally {
                    out.close();
                }
            }
        }
        finally {
            this.close();
        }
    }

    public String makeIndexPath(String path) {
        if (this.indexPath != null && !this.indexPath.equals("")) {
            return this.indexPath + File.separator + path;
        }
        return path;
    }

    private static ExportProfile createExportProfile(String basePath, String name) throws IOException {
        if (name == null) {
            return DefaultExportProfile.instance();
        }
        File file = new File(name);
        String profile = file.getName();
        if ("all".equals(profile)) {
            return DefaultExportProfile.instance();
        }
        if ("core".equals(profile)) {
            return new CoreExportProfile(basePath);
        }
        return new CustomExportProfile(name);
    }

    private void exportStatistics(IndexWriter writer) throws IOException {
        Document doc = new Document();
        Date date = new Date();
        doc.add((Fieldable)new Field("type", "statistics", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("stats_build_date", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    protected void exportOntologyCategories(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "ontology", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("oc_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("oc_o_id", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("oc_name", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("oc_description", parts[3], Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    protected void exportOntologies(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "ontology", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("o_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("o_name", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    public static Map<String, String> loadColours(String path) throws IOException {
        HashMap<String, String> colours = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("(.*?)\\s+([A-Fa-f0-9]+)\\s*(//.*)?");
        BufferedReader reader = new BufferedReader(new FileReader(path));
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            String colour = matcher.group(2);
            String groupType = matcher.group(1);
            colours.put(groupType, colour);
            line = reader.readLine();
        }
        return colours;
    }

    private static void populateOrganism(Organism organism, String[] parts) {
        organism.setId(Long.parseLong(parts[0]));
        organism.setName(parts[1]);
        organism.setDescription(parts[2]);
    }

    private static void processFile(String basePath, String fileName, FileHandler handler) throws IOException {
        String path = Generic2LuceneExporter.join(File.separator, new String[]{basePath, fileName});
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "utf-8"));
        String line = reader.readLine();
        while (line != null && handler.process(line)) {
            line = reader.readLine();
        }
        reader.close();
    }

    public void setNetworkGroupColours(Map<String, String> colours) {
        this.networkGroupColours = colours;
    }

    private static Analyzer createAnalyzer() {
        return LuceneMediator.createDefaultAnalyzer();
    }

    public void exportOrganism(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "organism", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("organism_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("organism_name", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("organism_desc", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("organism_alias", parts[3], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("organism_o_id", parts[4], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("organism_tax_id", parts[5], Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    public void exportGroup(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        String colour = this.networkGroupColours.get(parts[2]);
        if (colour == null) {
            colour = "000000";
        }
        doc.add((Fieldable)new Field("type", "group", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("group_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("group_name", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("group_code", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("group_description", parts[3], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("group_organism_id", parts[4], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("group_colour", colour, Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    public void exportNetwork(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "network", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("network_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("network_name", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("network_metadata_id", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("network_desc", parts[3], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("network_selected", parts[4].equals("0") ? "false" : "true", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("network_group_id", parts[5], Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    public void exportNetworkMetadata(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "metadata", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_source", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_reference", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_pubmed_id", parts[3], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_authors", parts[4], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_publication", parts[5], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_year", parts[6], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_processing", parts[7], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_network", parts[8], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_alias", parts[9], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_interactions", parts[10], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_dynamic_range", parts[11], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_edge_weight_dist", parts[12], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_access_stats", parts[13], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("metadata_comment", parts[14], Field.Store.YES, Field.Index.ANALYZED));
        if (parts.length > 15) {
            doc.add((Fieldable)new Field("metadata_other", parts[15], Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("metadata_title", parts[16], Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("metadata_url", parts[17], Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("metadata_source_url", parts[18], Field.Store.YES, Field.Index.ANALYZED));
        }
        writer.addDocument(doc);
    }

    public void exportNode(IndexWriter writer, String[] parts, String organismId) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "node", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("node_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("node_name", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("node_genedata_id", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("node_organism_id", organismId, Field.Store.NO, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    public void exportGene(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "gene", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("gene_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("gene", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("gene_namingsource_id", parts[3], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("node", parts[4], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("gene_organism_id", parts[5], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("gene_selected", parts[6].equals("0") ? "false" : "true", Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    public void exportNamingSource(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "namingsource", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("namingsource_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("namingsource_name", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("namingsource_rank", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        String namingSource = parts[3].length() > 0 ? parts[3] : "";
        doc.add((Fieldable)new Field("namingsource_short_name", namingSource, Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    public void exportGeneData(IndexWriter writer, String[] parts, String externalId, long namingSourceId) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "genedata", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("genedata_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("genedata_desc", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        if (externalId != null) {
            doc.add((Fieldable)new Field("genedata_external_id", externalId, Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("genedata_namingsource_id", String.valueOf(namingSourceId), Field.Store.YES, Field.Index.ANALYZED));
        }
        writer.addDocument(doc);
    }

    protected void exportTag(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "tag", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("tag_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("tag_name", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    protected void exportNetworkTagAssoc(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "nta", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("nta_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("nta_network_id", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("nta_tag_id", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    protected void exportAttributeGroup(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "attributegroup", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_organism_id", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_name", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_code", parts[3], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_description", parts[4], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_linkout_label", parts[5], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_linkout_url", parts[6], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_default_selected", parts[7], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_publication_name", parts[8], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("atg_publication_url", parts[9], Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    protected void exportAttribute(IndexWriter writer, String[] parts) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field("type", "attribute", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("at_id", parts[0], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("at_organism_id", parts[1], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("at_atg_id", parts[2], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("at_external_id", parts[3], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("at_name", parts[4], Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("at_description", parts[5], Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
    }

    public String getGenericDbPath() {
        return this.genericDbPath;
    }

    public void setGenericDbPath(String genericDbPath) {
        this.genericDbPath = genericDbPath;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public ConfigObj getConfig() {
        return this.config;
    }

    public void setConfig(ConfigObj config) {
        this.config = config;
    }

    static interface FileHandler {
        public boolean process(String var1) throws IOException;
    }
}

