/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene.exporter;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexUpdater {
    private File basePath;
    private Analyzer analyzer;

    public IndexUpdater(File basePath, Analyzer analyzer) {
        this.basePath = basePath;
        this.analyzer = analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNetworkStats(long organismId, long networkId, long newInteractionCount) throws IOException {
        IndexWriter writer = this.openIndexWriter(organismId);
        try {
            Document metadata;
            String metadataId;
            IndexReader reader = writer.getReader();
            IndexSearcher searcher = new IndexSearcher(reader);
            try {
                Document document = this.getFirst(searcher, (Query)new TermQuery(new Term("network_id", String.valueOf(networkId))));
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Network with id=%d and organism id=%d does not exist", networkId, organismId));
                }
                metadataId = document.get("network_metadata_id");
                metadata = this.getFirst(searcher, (Query)new TermQuery(new Term("metadata_id", metadataId)));
                if (metadata == null) {
                    throw new IllegalArgumentException(String.format("Metadata id=%s for network id=%d and organism id=%d does not exist", metadataId, networkId, organismId));
                }
            }
            finally {
                searcher.close();
                reader.close();
            }
            System.out.println(metadata.get("metadata_interactions"));
            metadata.removeField("metadata_interactions");
            metadata.add((Fieldable)new Field("metadata_interactions", String.valueOf(newInteractionCount), Field.Store.YES, Field.Index.ANALYZED));
            writer.updateDocument(new Term("metadata_id", String.valueOf(metadataId)), metadata, this.analyzer);
            writer.commit();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNetworkIsDefault(long organismId, long networkId, boolean isDefault) throws IOException {
        IndexWriter writer = this.openIndexWriter(organismId);
        try {
            Document document;
            IndexReader reader = writer.getReader();
            IndexSearcher searcher = new IndexSearcher(reader);
            try {
                document = this.getFirst(searcher, (Query)new TermQuery(new Term("network_id", String.valueOf(networkId))));
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Network with id=%d and organism id=%d does not exist", networkId, organismId));
                }
            }
            finally {
                searcher.close();
                reader.close();
            }
            document.removeField("network_selected");
            document.add((Fieldable)new Field("network_selected", isDefault ? "true" : "false", Field.Store.YES, Field.Index.ANALYZED));
            writer.updateDocument(new Term("network_id", String.valueOf(networkId)), document, this.analyzer);
            writer.commit();
        }
        finally {
            writer.close();
        }
    }

    private Document getFirst(IndexSearcher searcher, Query query) throws IOException {
        TopDocs topDocs = searcher.search(query, 1);
        if (topDocs.scoreDocs.length == 0) {
            return null;
        }
        return searcher.doc(topDocs.scoreDocs[0].doc);
    }

    private IndexWriter openIndexWriter(long organismId) throws IOException {
        String path = String.format("%s%s%d", this.basePath.getPath(), File.separator, organismId);
        FSDirectory directory = FSDirectory.open((File)new File(path));
        return new IndexWriter((Directory)directory, this.analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
    }
}

