/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.genemania.util.ProfilingUtils;

public class Profiler {
    private static Logger LOG = Logger.getLogger(Profiler.class);
    private Hashtable<String, Profile> markers = new Hashtable();
    private List<Metric> metrics = new ArrayList<Metric>();

    public void startSession() {
        ProfilingUtils.clearMemory();
        this.markers = new Hashtable();
        this.metrics = new ArrayList<Metric>();
    }

    public void stopSession() {
        this.markers = new Hashtable();
        this.metrics = new ArrayList<Metric>();
        ProfilingUtils.clearMemory();
    }

    public void addStartMarker(String pid) {
        System.gc();
        Profile profile = new Profile(pid);
        this.markers.put(Profile.getStartId(pid), profile);
    }

    public void addStopMarker(String pid) {
        Profile profile = new Profile(pid);
        this.markers.put(Profile.getStopId(pid), profile);
        Metric metric = new Metric(pid);
        this.metrics.add(metric);
    }

    public synchronized void printMetrics() {
        for (Metric metric : this.metrics) {
            LOG.info((Object)metric.toString());
        }
    }

    public class Metric {
        private String pid;
        private long duration;
        private long memory;

        public Metric(String pid) {
            Profile stopMarker;
            this.pid = pid;
            Profile startMarker = (Profile)Profiler.this.markers.get(Profile.getStartId(pid));
            if (startMarker == null) {
                LOG.warn((Object)("\"" + pid + "\" process has no start marker"));
            }
            if ((stopMarker = (Profile)Profiler.this.markers.get(Profile.getStopId(pid))) == null) {
                LOG.warn((Object)("\"" + pid + "\" process has no stop marker"));
            }
            if (startMarker != null && stopMarker != null) {
                this.duration = stopMarker.getTimestamp() - startMarker.getTimestamp();
                this.memory = stopMarker.getUsedMemory() - startMarker.getUsedMemory();
            }
        }

        public String getPid() {
            return this.pid;
        }

        public long getDuration() {
            return this.duration;
        }

        public long getMemory() {
            return this.memory;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.pid);
            ret.append(": duration=");
            if (this.duration < 1000L) {
                ret.append(this.duration);
                ret.append("ms");
            } else {
                ret.append(Math.round(this.duration / 1000L));
                ret.append("s");
            }
            ret.append(", memory=");
            if (this.memory > 0L) {
                if (this.memory < 1024L) {
                    ret.append(this.memory);
                    ret.append(" bytes");
                } else if (this.memory < 0x100000L) {
                    ret.append(this.memory / 1024L);
                    ret.append("kb");
                } else {
                    ret.append(this.memory / 0x100000L);
                    ret.append("Mb");
                }
            } else {
                ret.append("???");
            }
            return ret.toString();
        }
    }

    public static class Profile {
        private static String id;
        private long timestamp;
        private long usedMemory;

        public Profile(String id) {
            Profile.id = id;
            this.timestamp = System.currentTimeMillis();
            this.usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        }

        public static String getStartId(String pid) {
            return pid + "_start";
        }

        public static String getStopId(String pid) {
            return pid + "_stop";
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getUsedMemory() {
            return this.usedMemory;
        }
    }
}

