/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.util;

import org.apache.log4j.Logger;

public class ProfilingUtils {
    private static Logger LOG = Logger.getLogger(ProfilingUtils.class);

    public static void clearMemory() {
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 0x40000000L;
    }

    public static long getUsedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long getUsedMemory(String mu) {
        long ret = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if ("K".equalsIgnoreCase(mu)) {
            ret /= 1024L;
        } else if ("M".equalsIgnoreCase(mu)) {
            ret /= 0x100000L;
        } else if ("G".equalsIgnoreCase(mu)) {
            ret /= 0x40000000L;
        }
        return ret;
    }

    public static long calculateMemoryUsage(ObjectFactory factory) {
        Object handle = factory.makeObject();
        long mem0 = ProfilingUtils.getUsedMemory();
        long mem1 = ProfilingUtils.getUsedMemory();
        handle = null;
        ProfilingUtils.clearMemory();
        mem0 = ProfilingUtils.getUsedMemory();
        handle = factory.makeObject();
        ProfilingUtils.clearMemory();
        mem1 = ProfilingUtils.getUsedMemory();
        return mem1 - mem0;
    }

    public static void showMemoryUsage(ObjectFactory factory) {
        long mem = ProfilingUtils.calculateMemoryUsage(factory);
        System.out.println(factory.getClass().getName() + " produced " + factory.makeObject().getClass().getName() + " which took " + mem + " bytes");
    }

    public static interface ObjectFactory {
        public Object makeObject();
    }
}

