/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Metadata {
    private final Properties configProperties = new Properties();

    public Metadata() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("config.properties");
            if (stream == null) {
                return;
            }
            this.configProperties.load(stream);
        }
        catch (IOException e) {
            this.log(e);
        }
    }

    public String getCytoscapeVersion() {
        return this.getConfigProperty("cytoscapeVersion");
    }

    public String getBuildId() {
        return this.getConfigProperty("buildNumber");
    }

    public String getConfigProperty(String key) {
        String value = this.configProperties.getProperty(key);
        if (value == null || value.length() == 0 || value.startsWith("${")) {
            return null;
        }
        return value;
    }

    private void log(IOException e) {
        Logger logger = Logger.getLogger(Metadata.class);
        logger.error((Object)"Unexpected exception", (Throwable)e);
    }
}

