/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.engine.Mania2;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.engine.cache.SynchronizedObjectCache;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.apps.AbstractPluginDataApp;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.Namespace;
import org.genemania.util.NullProgressReporter;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXException;

public abstract class AbstractImportApp
extends AbstractPluginDataApp {
    @Option(name="--filename", required=true, usage="file to import")
    protected String fFilename;
    @Option(name="--name", required=true, usage="name of new network")
    protected String fNetworkName;
    @Option(name="--group", usage="group to which new network should be added.  If the group doesn't exist, it gets created; defaults to 'Other'")
    protected String fNetworkGroupName = "other";
    @Option(name="--group-description", usage="description of new network group.  Only applicable if a new network group is being created")
    protected String fNetworkGroupDescription = "Other";
    @Option(name="--color", usage="a 6 digit hex representation of the color of the network being created in RRGGBB format; defaults to '000000' (black)")
    protected String fGroupColor = "000000";
    @Option(name="--description", usage="description of new network")
    protected String fDescription;
    @Option(name="--organism", required=true, usage="organism name")
    protected String fOrganismName;
    @Option(name="--namespace")
    protected String fNamespaceName = "user";
    protected Mania2 fMania;
    protected File fFile;
    protected Organism fOrganism;
    protected InteractionNetworkGroup fNetworkGroup;
    protected Namespace fNamespace;
    private static final Pattern COLOR_PATTERN = Pattern.compile("[0-9a-fA-F]{6}");

    protected void initialize() throws ApplicationException, DataStoreException, IOException {
        try {
            DataSetManager manager = AbstractImportApp.createDataSetManager();
            this.fData = manager.open(new File(this.fDataPath));
            this.fData.setHeadless(true);
            DataCache cache = new DataCache((IObjectCache)new SynchronizedObjectCache((IObjectCache)new MemObjectCache(this.fData.getObjectCache(NullProgressReporter.instance(), false))));
            this.fMania = new Mania2(cache);
            this.fNamespace = this.fNamespaceName.equalsIgnoreCase("core") ? Namespace.CORE : Namespace.USER;
            this.fFile = new File(this.fFilename);
            File parent = this.fFile.getParentFile();
            if (parent != null && !parent.exists()) {
                throw new ApplicationException(String.format("Cannot write to file: %s", this.fFile.getCanonicalPath()));
            }
            if (!this.fFile.isFile() && this.fFile.exists()) {
                throw new ApplicationException(String.format("Cannot write output because file already exists but isn't a regular file: %s", this.fFile.getCanonicalPath()));
            }
            this.fOrganism = this.parseOrganism(this.fData, this.fOrganismName);
            if (this.fOrganism == null) {
                throw new ApplicationException(String.format("Unrecognized organism: %s", this.fOrganismName));
            }
            if (this.fNetworkName.trim().length() == 0) {
                throw new ApplicationException("Network name cannot be blank");
            }
            this.fNetworkGroup = this.parseGroup(this.fOrganism, this.fNetworkGroupName);
            if (this.fNetworkGroup == null) {
                if (this.fNetworkGroupDescription.trim().length() == 0) {
                    throw new ApplicationException("Network description cannot be blank");
                }
                if (!COLOR_PATTERN.matcher(this.fGroupColor).matches()) {
                    throw new ApplicationException("Network group color should be in RRGGBB hex format");
                }
                this.fNetworkGroup = new InteractionNetworkGroup();
                this.fNetworkGroup.setName(this.fNetworkGroupDescription);
                this.fNetworkGroup.setDescription(this.fNetworkGroupDescription);
                this.fNetworkGroup.setCode(this.fNetworkGroupName);
            }
            if (this.networkExists(this.fNetworkName, this.fOrganism, this.fNetworkGroup)) {
                throw new ApplicationException(String.format("Network named '%s' already exists in group '%s'", this.fNetworkName, this.fNetworkGroup.getName()));
            }
        }
        catch (SAXException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private boolean networkExists(String networkName, Organism organism, InteractionNetworkGroup group) {
        for (InteractionNetworkGroup otherGroup : organism.getInteractionNetworkGroups()) {
            if (!otherGroup.getCode().equals(group.getCode())) continue;
            for (InteractionNetwork network : otherGroup.getInteractionNetworks()) {
                if (!network.getName().equals(networkName)) continue;
                return true;
            }
        }
        return false;
    }
}

