/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.NodeMediator;
import org.genemania.plugin.apps.AbstractPluginApp;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class AbstractPluginDataApp
extends AbstractPluginApp {
    protected DataSet fData;
    @Option(name="--data", required=true, usage="path to a GeneMANIA data set (e.g. gmdata-2010-06-24)")
    protected String fDataPath;
    @Option(name="--threads", usage="number of parallel threads (default = 1)")
    protected int fThreads = 1;
    @Option(name="--verbose", usage="give more details about what's happening")
    protected boolean fVerbose;
    @Argument
    protected List<String> fArguments = new ArrayList<String>();

    protected List<String> getArguments() {
        return this.fArguments;
    }

    protected int getThreads() {
        return this.fThreads;
    }

    protected String getDataPath() {
        return this.fDataPath;
    }

    protected InteractionNetworkGroup parseGroup(Organism organism, String name) {
        for (InteractionNetworkGroup group : organism.getInteractionNetworkGroups()) {
            if (group.getName().equals(name)) {
                return group;
            }
            if (!group.getCode().equals(name)) continue;
            return group;
        }
        return null;
    }

    protected Collection<Collection<Long>> collapseNetworks(Collection<? extends Group<?, ?>> networks) {
        ArrayList<Collection<Long>> result = new ArrayList<Collection<Long>>();
        ArrayList<Group<InteractionNetworkGroup, InteractionNetwork>> groups = new ArrayList<Group<InteractionNetworkGroup, InteractionNetwork>>();
        for (Group<?, ?> group : networks) {
            Group<InteractionNetworkGroup, InteractionNetwork> adapted = group.adapt(InteractionNetworkGroup.class, InteractionNetwork.class);
            if (adapted == null) continue;
            groups.add(adapted);
        }
        Collections.sort(groups, new Comparator<Group<InteractionNetworkGroup, InteractionNetwork>>(){

            @Override
            public int compare(Group<InteractionNetworkGroup, InteractionNetwork> g1, Group<InteractionNetworkGroup, InteractionNetwork> g2) {
                return (int)Math.signum(g1.getModel().getId() - g2.getModel().getId());
            }
        });
        for (Group<Object, Object> group : groups) {
            HashSet<Long> groupMembers = new HashSet<Long>();
            for (Network<Object> network : group.getNetworks()) {
                groupMembers.add(((InteractionNetwork)network.getModel()).getId());
            }
            if (groupMembers.isEmpty()) continue;
            ArrayList sorted = new ArrayList(groupMembers);
            Collections.sort(sorted);
            result.add(sorted);
        }
        return result;
    }

    protected Collection<Long> collapseAttributeGroups(Collection<Group<?, ?>> groups) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Group<?, ?> group : groups) {
            Group<Object, AttributeGroup> adapted = group.adapt(Object.class, AttributeGroup.class);
            if (adapted == null) continue;
            for (Network<AttributeGroup> network : adapted.getNetworks()) {
                result.add(network.getModel().getId());
            }
        }
        return result;
    }

    protected void printNetworks(String organismName) throws DataStoreException {
        Organism organism = this.parseOrganism(this.fData, organismName);
        if (organism == null) {
            System.err.println(String.format("Unrecognized organism: %s", organismName));
        }
        Collection groups = organism.getInteractionNetworkGroups();
        for (InteractionNetworkGroup group : groups) {
            Collection networks = group.getInteractionNetworks();
            for (InteractionNetwork network : networks) {
                System.out.println(network.getName());
            }
        }
    }

    protected void printGenes(String organismName) throws DataStoreException {
        Organism organism = this.parseOrganism(this.fData, organismName);
        if (organism == null) {
            System.err.println(String.format("Unrecognized organism: %s", organismName));
        }
        long organismId = organism.getId();
        List<Long> nodeIds = this.fData.getNodeIds(organismId);
        NodeMediator mediator = this.fData.getMediatorProvider().getNodeMediator();
        for (long nodeId : nodeIds) {
            Node node = mediator.getNode(nodeId, organismId);
            ArrayList genes = new ArrayList(node.getGenes());
            Collections.sort(genes, new Comparator<Gene>(){

                @Override
                public int compare(Gene g1, Gene g2) {
                    return g2.getNamingSource().getRank() - g1.getNamingSource().getRank();
                }
            });
            boolean first = true;
            for (Gene gene : genes) {
                if (!first) {
                    System.out.print("\t");
                }
                System.out.print(gene.getSymbol());
                first = false;
            }
            System.out.println();
        }
    }
}

