/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.genemania.engine.apps.VectorCrossValidator;
import org.genemania.plugin.apps.AbstractValidationApp;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class CrossValidator
extends AbstractValidationApp {
    @Option(name="--networks", usage="comma delimited list of network ids or group codes to use eg '3,4,19,coexp', or 'all', or 'default', or 'preferred' for our selection heuristic.", required=true)
    private String fNetworkList;
    @Option(name="--exclude-networks", usage="comma delimited list of network ids or group codes to exclude eg '3,4,19,coexp', or 'all', or 'default', or 'preferred' for our selection heuristic.")
    private String fNetworkExcludeList;
    @Option(name="--labels", usage="optional, write validation set labels for each fold to file, defaults to 'false'")
    private boolean fWriteLabels = false;

    private void doValidation() throws Exception {
        this.checkFile(this.fQueryFile);
        this.checkWritable(this.fOutputFile);
        VectorCrossValidator vcv = this.createValidator(this.fNetworkList, this.fNetworkExcludeList);
        vcv.setWriteLabels(this.fWriteLabels);
        vcv.setOutFilename(this.fOutputFile);
        long start = System.currentTimeMillis();
        vcv.initValidation();
        vcv.crossValidate();
        long duration = System.currentTimeMillis() - start;
        int total = vcv.getQueryCounter();
        System.err.println(String.format("Performed %d predictions in %.2fs", total, (double)duration / 1000.0));
    }

    public static void main(String[] args) throws Exception {
        Logger.getLogger((String)"org.genemania").setLevel(Level.WARN);
        CrossValidator validator = new CrossValidator();
        CmdLineParser parser = new CmdLineParser((Object)validator);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println(String.format("\nUsage: %s options\n", validator.getClass().getSimpleName()));
            parser.printUsage((OutputStream)System.err);
            return;
        }
        validator.initialize();
        validator.doValidation();
    }
}

