/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.lucene.LuceneMediator;
import org.genemania.mediator.lucene.LuceneNetworkMediator;
import org.genemania.plugin.data.lucene.LuceneModelWriter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class IndexPostProcessor {
    @Option(name="--source", usage="source index directory", required=true)
    private String fSourcePath;
    @Option(name="--target", usage="target index directory", required=true)
    private String fTargetPath;

    public static void main(String[] args) throws Exception {
        IndexPostProcessor processor = new IndexPostProcessor();
        CmdLineParser parser = new CmdLineParser((Object)processor);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            IndexPostProcessor.printUsage(parser);
            return;
        }
        processor.process();
    }

    private static void printUsage(CmdLineParser parser) {
        System.err.println(String.format("\nGeneral usage: java %s options\n", IndexPostProcessor.class.getName()));
        parser.printUsage((OutputStream)System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException, ApplicationException {
        File source = new File(this.fSourcePath);
        File target = new File(this.fTargetPath);
        Pattern pattern = Pattern.compile("\\d+");
        if (!source.isDirectory() || !target.isDirectory()) {
            throw new IllegalArgumentException("Both the source and target index directories must exist");
        }
        for (File file : target.listFiles()) {
            String organismId;
            Matcher matcher;
            if (!file.isDirectory() || !(matcher = pattern.matcher(organismId = file.getName())).matches()) continue;
            File sourceFile = new File(source.getPath() + File.separator + organismId);
            FSDirectory targetDirectory = FSDirectory.open((File)file);
            IndexSearcher targetSearcher = new IndexSearcher((Directory)targetDirectory);
            IndexSearcher sourceSearcher = new IndexSearcher((Directory)FSDirectory.open((File)sourceFile));
            Analyzer analyzer = LuceneMediator.createDefaultAnalyzer();
            LuceneNetworkMediator targetMediator = new LuceneNetworkMediator((Searcher)targetSearcher, analyzer);
            LuceneNetworkMediator sourceMediator = new LuceneNetworkMediator((Searcher)sourceSearcher, analyzer);
            HashMap<InteractionNetwork, InteractionNetworkGroup> networksToUpdate = new HashMap<InteractionNetwork, InteractionNetworkGroup>();
            for (InteractionNetwork targetNetwork : targetMediator.getAllNetworks()) {
                InteractionNetwork sourceNetwork = sourceMediator.getNetwork(targetNetwork.getId());
                if (!this.hasChanges(sourceNetwork, targetNetwork)) continue;
                InteractionNetworkGroup group = sourceMediator.getNetworkGroupForNetwork(sourceNetwork.getId());
                networksToUpdate.put(sourceNetwork, group);
                System.out.printf("Updated %s\t%s\t%s.\n", group.getName(), sourceNetwork.getId(), sourceNetwork.getName());
            }
            if (networksToUpdate.size() == 0) {
                return;
            }
            IndexWriter indexWriter = new IndexWriter((Directory)targetDirectory, analyzer, false, IndexWriter.MaxFieldLength.UNLIMITED);
            LuceneModelWriter modelWriter = new LuceneModelWriter(indexWriter);
            try {
                for (Map.Entry entry : networksToUpdate.entrySet()) {
                    InteractionNetwork network = (InteractionNetwork)entry.getKey();
                    InteractionNetworkGroup group = (InteractionNetworkGroup)entry.getValue();
                    modelWriter.deleteNetwork(network);
                    modelWriter.addNetwork(network, group);
                }
            }
            finally {
                modelWriter.close();
            }
        }
    }

    private boolean hasChanges(InteractionNetwork sourceNetwork, InteractionNetwork targetNetwork) {
        NetworkMetadata targetMetadata = targetNetwork.getMetadata();
        NetworkMetadata sourceMetadata = sourceNetwork.getMetadata();
        if (sourceMetadata != null && targetMetadata != null && sourceMetadata.getInteractionCount() != targetMetadata.getInteractionCount()) {
            return true;
        }
        return sourceNetwork.isDefaultSelected() != targetNetwork.isDefaultSelected();
    }
}

