/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.genemania.data.normalizer.DataFileClassifier;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.data.normalizer.DataNormalizer;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.data.normalizer.NormalizationResult;
import org.genemania.data.normalizer.OrganismClassifier;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.dto.UploadNetworkEngineRequestDto;
import org.genemania.dto.UploadNetworkEngineResponseDto;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.ManiaUtils;
import org.genemania.plugin.apps.AbstractImportApp;
import org.genemania.plugin.data.IModelManager;
import org.genemania.plugin.data.IModelWriter;
import org.genemania.plugin.data.Namespace;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class NetworkImporter
extends AbstractImportApp {
    private static final int DEFAULT_LINES_TO_SAMPLE = 200;
    private FileUtils fileUtils = new FileUtils();

    public static void main(String[] args) throws Exception {
        Logger.getLogger((String)"org.genemania").setLevel(Level.FATAL);
        NetworkImporter importer = new NetworkImporter();
        CmdLineParser parser = new CmdLineParser((Object)importer);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println(String.format("\nUsage: %s options\n", NetworkImporter.class.getSimpleName()));
            parser.printUsage((OutputStream)System.err);
            return;
        }
        importer.handleArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleArguments() throws ApplicationException, DataStoreException, IOException {
        this.initialize();
        if (this.fVerbose) {
            Logger.getLogger((String)"org.genemania").setLevel(Level.INFO);
        }
        if (this.fDescription == null) {
            this.fDescription = "";
        }
        long networkId = this.fData.getNextAvailableId(InteractionNetwork.class, this.fNamespace);
        InteractionNetwork network = new InteractionNetwork();
        network.setName(this.fNetworkName);
        network.setDescription(this.fDescription);
        network.setId(networkId);
        DataImportSettings settings = new DataImportSettings();
        settings.setSource(this.fFile.getName());
        settings.setNetworkGroup(this.fNetworkGroup);
        settings.setNetwork(network);
        OrganismClassifier organismClassifier = new OrganismClassifier(this.fData.getGeneClassifier());
        organismClassifier.classify(settings, this.fileUtils.getUncompressedReader(this.fFile), 200);
        settings.setOrganism(this.fOrganism);
        DataFileClassifier classifier = new DataFileClassifier();
        classifier.classify(settings, this.fileUtils.getUncompressedStream(this.fFile), 200);
        System.err.printf("Detected file type: %s\n", settings.getDataFormat());
        System.err.printf("Detected file layout: %s\n", settings.getDataLayout());
        System.err.printf("Processing method: %s\n", settings.getProcessingMethod());
        DataNormalizer normalizer = new DataNormalizer();
        GeneCompletionProvider2 provider = this.fData.getCompletionProvider(this.fOrganism);
        ProgressReporter progress = NullProgressReporter.instance();
        Reader rawReader = this.fileUtils.getUncompressedReader(this.fFile);
        try {
            File tempFile = File.createTempFile(this.getClass().getName(), ".txt");
            try {
                NormalizationResult result;
                FileWriter normalizedWriter = new FileWriter(tempFile);
                try {
                    result = normalizer.normalize(settings, provider, rawReader, (Writer)normalizedWriter, progress);
                }
                finally {
                    ((Writer)normalizedWriter).close();
                }
                FileReader normalizedReader = new FileReader(tempFile);
                try {
                    UploadNetworkEngineRequestDto request = ManiaUtils.createRequest(settings, normalizedReader, progress);
                    if (this.fNamespace.equals((Object)Namespace.USER)) {
                        request.setNamespace("user");
                    } else {
                        request.setNamespace("CORE");
                    }
                    UploadNetworkEngineResponseDto response = this.fMania.uploadNetwork(request);
                    IModelManager manager = this.fData.createModelManager(this.fNamespace);
                    try {
                        IModelWriter writer = manager.getModelWriter();
                        if (this.fNetworkGroup.getId() == 0L) {
                            this.fNetworkGroup.setId(this.fData.getNextAvailableId(InteractionNetworkGroup.class, this.fNamespace).longValue());
                            writer.addGroup(this.fNetworkGroup, this.fOrganism, this.fGroupColor);
                        }
                        manager.installNetworkModel(settings, response, result);
                    }
                    finally {
                        manager.close();
                    }
                    this.printResults(result);
                }
                finally {
                    ((Reader)normalizedReader).close();
                }
            }
            finally {
                tempFile.delete();
            }
        }
        finally {
            rawReader.close();
        }
    }

    private void printResults(NormalizationResult result) {
        Set invalidSymbols;
        if (result.getDroppedEntries() > 0) {
            System.err.printf("Dropped rows: %d/%d\n", result.getDroppedEntries(), result.getTotalEntries());
        }
        if ((invalidSymbols = result.getInvalidSymbols()).size() > 0) {
            System.err.printf("Unrecognized gene symbols: %d\n", invalidSymbols.size());
            ArrayList sorted = new ArrayList(invalidSymbols);
            Collections.sort(sorted, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (String symbol : sorted) {
                System.err.printf("\t%s\n", symbol);
            }
        }
    }
}

