/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.completion;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import org.genemania.completion.CompletionConsumer;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.Gene;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.DynamicListModel;
import org.genemania.plugin.completion.PasteResult;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ProgressReporter;

public class CompletionTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private final GeneCompletionProvider2 provider;
    private final CompletionConsumer consumer;
    private final NetworkUtils networkUtils;
    private final UiUtils uiUtils;
    private final TaskDispatcher taskDispatcher;

    public CompletionTransferHandler(GeneCompletionProvider2 provider, CompletionConsumer consumer, NetworkUtils networkUtils, UiUtils uiUtils, TaskDispatcher taskDispatcher) {
        this.provider = provider;
        this.consumer = consumer;
        this.networkUtils = networkUtils;
        this.uiUtils = uiUtils;
        this.taskDispatcher = taskDispatcher;
    }

    @Override
    public boolean importData(JComponent comp, final Transferable t) {
        final PasteResult[] result = new PasteResult[1];
        GeneManiaTask task = new GeneManiaTask(Strings.completionTransferHandler_title2){

            @Override
            protected void runTask() throws Throwable {
                String data = (String)t.getTransferData(DataFlavor.stringFlavor);
                result[0] = CompletionTransferHandler.this.validate(data, this.progress);
            }
        };
        Frame parent = this.uiUtils.getFrame(comp);
        this.taskDispatcher.executeTask(task, parent, true, true);
        if (result[0] != null && result[0].hasIssues()) {
            this.showIssues(result[0], parent);
        }
        return super.importData(comp, t);
    }

    private JDialog createDialog(Container parent) {
        JDialog dialog = null;
        while (parent != null) {
            if (parent instanceof Frame) {
                dialog = new JDialog((Frame)parent, true);
                break;
            }
            if (parent instanceof Dialog) {
                dialog = new JDialog((Dialog)parent, true);
                break;
            }
            parent = parent.getParent();
        }
        if (dialog == null) {
            dialog = new JDialog();
        }
        return dialog;
    }

    private void showIssues(PasteResult result, Container parent) {
        Map<String, Integer> duplicates;
        ArrayList<String> unrecognizedGenes;
        JScrollPane scrollPane;
        final JDialog dialog = this.createDialog(parent);
        dialog.setTitle(Strings.completionTransferHandler_title);
        JPanel panel = this.uiUtils.createJPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(32, 32, 32, 32));
        panel.setLayout(new GridBagLayout());
        int xOffset = 0;
        Insets insets = new Insets(0, 4, 0, 4);
        Map<String, Set<String>> synonyms = result.getSynonyms();
        if (synonyms.size() > 0) {
            JLabel label = new JLabel(Strings.completionTransferHandlerSynonyms_label);
            panel.add((Component)label, new GridBagConstraints(xOffset, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            ArrayList<String> symbols = new ArrayList<String>();
            for (Map.Entry<String, Set<String>> entry : synonyms.entrySet()) {
                String preferredSymbol = entry.getKey();
                for (String symbol : entry.getValue()) {
                    symbols.add(String.format("%s (%s)", symbol, preferredSymbol));
                }
            }
            Collections.sort(symbols);
            scrollPane = new JScrollPane(new JList(new DynamicListModel(symbols)));
            panel.add((Component)scrollPane, new GridBagConstraints(xOffset, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
            ++xOffset;
        }
        if ((unrecognizedGenes = new ArrayList<String>(result.getUnrecognizedSymbols())).size() > 0) {
            JLabel label = new JLabel(Strings.completionTransferHandlerUnrecognizedGenes_label);
            panel.add((Component)label, new GridBagConstraints(xOffset, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            Collections.sort(unrecognizedGenes);
            scrollPane = new JScrollPane(new JList<String>(new DynamicListModel<String>(unrecognizedGenes)));
            panel.add((Component)scrollPane, new GridBagConstraints(xOffset, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
            ++xOffset;
        }
        if ((duplicates = result.getDuplicates()).size() > 0) {
            JLabel label = new JLabel(Strings.completionTransferHandlerDuplicateGenes_label);
            panel.add((Component)label, new GridBagConstraints(xOffset, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            ArrayList<String> duplicateGenes = new ArrayList<String>();
            for (Map.Entry<String, Integer> entry : duplicates.entrySet()) {
                duplicateGenes.add(String.format("%s (%d)", entry.getKey(), entry.getValue()));
            }
            Collections.sort(duplicateGenes);
            JScrollPane scrollPane2 = new JScrollPane(new JList(new DynamicListModel(duplicateGenes)));
            panel.add((Component)scrollPane2, new GridBagConstraints(xOffset, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
            ++xOffset;
        }
        JButton button = new JButton(Strings.completionTransferHandlerOkButton_label);
        button.setAlignmentX(0.5f);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        panel.add((Component)button, new GridBagConstraints(0, 2, xOffset, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        Container contents = dialog.getContentPane();
        contents.add(panel);
        dialog.setMinimumSize(new Dimension(300, 300));
        dialog.pack();
        dialog.setLocationByPlatform(true);
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasteResult validate(String data, ProgressReporter progress) {
        StringTokenizer tokenizer = new StringTokenizer(data);
        PasteResult result = new PasteResult(this.networkUtils);
        int valid = 0;
        try {
            while (tokenizer.hasMoreTokens()) {
                if (progress.isCanceled()) {
                    PasteResult pasteResult = result;
                    return pasteResult;
                }
                String token = tokenizer.nextToken();
                result.addDuplicate(token);
                Gene gene = this.provider.getGene(token);
                if (gene != null) {
                    result.addSynonym(gene);
                    this.consumer.consume(gene.getSymbol());
                    ++valid;
                } else {
                    result.addUnrecognizedSymbol(token);
                }
                progress.setStatus(String.format(Strings.completionTransferHandler_status, valid, result.getUnrecognizedSymbols().size()));
            }
        }
        finally {
            this.consumer.finish();
        }
        return result;
    }
}

