/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.completion;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.genemania.domain.Gene;
import org.genemania.plugin.NetworkUtils;

public class PasteResult {
    private final Set<String> unrecognizedSymbols = new HashSet<String>();
    private final Map<String, Set<String>> synonyms = new HashMap<String, Set<String>>();
    private final Map<String, Integer> duplicates = new HashMap<String, Integer>();
    private final NetworkUtils networkUtils;

    public PasteResult(NetworkUtils networkUtils) {
        this.networkUtils = networkUtils;
    }

    public Map<String, Integer> getDuplicates() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : this.duplicates.entrySet()) {
            Integer count = entry.getValue();
            if (count <= 1) continue;
            result.put(entry.getKey(), count);
        }
        return result;
    }

    public Map<String, Set<String>> getSynonyms() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : this.synonyms.entrySet()) {
            String key = entry.getKey();
            Set<String> value = entry.getValue();
            if (value.size() <= 1) continue;
            result.put(key, value);
        }
        return result;
    }

    public Collection<String> getUnrecognizedSymbols() {
        return Collections.unmodifiableSet(this.unrecognizedSymbols);
    }

    public boolean hasIssues() {
        if (this.unrecognizedSymbols.size() > 0) {
            return true;
        }
        for (Set<String> geneSynonyms : this.synonyms.values()) {
            if (geneSynonyms.size() <= 1) continue;
            return true;
        }
        for (Integer count : this.duplicates.values()) {
            if (count <= 1) continue;
            return true;
        }
        return false;
    }

    public void addUnrecognizedSymbol(String symbol) {
        this.unrecognizedSymbols.add(symbol);
    }

    public void addSynonym(Gene gene) {
        Gene preferredGene = this.networkUtils.getPreferredGene(gene.getNode());
        String preferredSymbol = preferredGene.getSymbol();
        Set<String> geneSynonyms = this.synonyms.get(preferredSymbol);
        if (geneSynonyms == null) {
            geneSynonyms = new HashSet<String>();
            this.synonyms.put(preferredSymbol, geneSynonyms);
        }
        geneSynonyms.add(gene.getSymbol());
    }

    public void addDuplicate(String symbol) {
        Integer count = this.duplicates.get(symbol);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        this.duplicates.put(symbol, count);
    }
}

