/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.controllers;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.Node;
import org.genemania.plugin.controllers.IGeneProvider;

public class RankedGeneProvider
implements IGeneProvider {
    protected final Map<Long, Integer> rankings;
    private final Comparator<Gene> comparator;

    public RankedGeneProvider(List<GeneNamingSource> allSources, List<GeneNamingSource> namingSourcePreferences) {
        this.rankings = this.createNamingSourceRankings(allSources, namingSourcePreferences);
        this.comparator = this.createComparator();
    }

    @Override
    public Gene getGene(Node node) {
        return Collections.min(node.getGenes(), this.comparator);
    }

    Map<Long, Integer> createNamingSourceRankings(List<GeneNamingSource> baseRankings, List<GeneNamingSource> userPreferences) {
        HashMap<Long, Integer> rankings = new HashMap<Long, Integer>();
        for (GeneNamingSource source : baseRankings) {
            rankings.put(source.getId(), Integer.valueOf(source.getRank()));
        }
        Integer maxRank = (Integer)Collections.max(rankings.values());
        if (maxRank == null) {
            maxRank = 0;
        }
        int nextRank = maxRank + userPreferences.size();
        for (GeneNamingSource source : userPreferences) {
            rankings.put(source.getId(), nextRank);
            --nextRank;
        }
        return rankings;
    }

    protected Comparator<Gene> createComparator() {
        return new Comparator<Gene>(){

            @Override
            public int compare(Gene gene1, Gene gene2) {
                GeneNamingSource source1 = gene1.getNamingSource();
                GeneNamingSource source2 = gene2.getNamingSource();
                Integer rank1 = RankedGeneProvider.this.rankings.get(source1.getId());
                Integer rank2 = RankedGeneProvider.this.rankings.get(source2.getId());
                return rank2 - rank1;
            }
        };
    }
}

