/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.controllers;

import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneNamingSource;
import org.genemania.plugin.controllers.RankedGeneProvider;

public class RankedGeneProviderWithUniprotHack
extends RankedGeneProvider {
    public static final String UNIPROT_AC = "Uniprot AC";
    public static final String UNIPROT_ID = "Uniprot ID";
    Pattern UNIPROT_ACCESSION = Pattern.compile("([A-NR-Z][0-9][A-Z][A-Z0-9][A-Z0-9][0-9])|([O-Q][0-9][A-Z0-9][A-Z0-9][A-Z0-9][0-9])");
    private final int comparisonModifier;

    public RankedGeneProviderWithUniprotHack(List<GeneNamingSource> baseNamingSources, List<GeneNamingSource> namingSourcePreferences) {
        super(baseNamingSources, namingSourcePreferences);
        int acRank = Integer.MIN_VALUE;
        int idRank = Integer.MIN_VALUE;
        int rank = 0;
        for (GeneNamingSource source : namingSourcePreferences) {
            if (source.getName().equals(UNIPROT_ID)) {
                idRank = rank;
            } else if (source.getName().equals(UNIPROT_AC)) {
                acRank = rank;
            }
            ++rank;
        }
        this.comparisonModifier = idRank >= acRank ? 1 : -1;
    }

    @Override
    protected Comparator<Gene> createComparator() {
        return new Comparator<Gene>(){

            @Override
            public int compare(Gene gene1, Gene gene2) {
                long id2;
                GeneNamingSource source1 = gene1.getNamingSource();
                GeneNamingSource source2 = gene2.getNamingSource();
                long id1 = source1.getId();
                if (id1 == (id2 = source2.getId()) && source1.getName().equals(RankedGeneProviderWithUniprotHack.UNIPROT_ID)) {
                    if (RankedGeneProviderWithUniprotHack.this.UNIPROT_ACCESSION.matcher(gene1.getSymbol()).matches()) {
                        return -RankedGeneProviderWithUniprotHack.this.comparisonModifier;
                    }
                    if (RankedGeneProviderWithUniprotHack.this.UNIPROT_ACCESSION.matcher(gene2.getSymbol()).matches()) {
                        return RankedGeneProviderWithUniprotHack.this.comparisonModifier;
                    }
                    return 0;
                }
                Integer rank1 = (Integer)RankedGeneProviderWithUniprotHack.this.rankings.get(id1);
                Integer rank2 = (Integer)RankedGeneProviderWithUniprotHack.this.rankings.get(id2);
                return rank2 - rank1;
            }
        };
    }
}

