/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.genemania.engine.cache.SoftRefObjectCache;
import org.genemania.plugin.AbstractGeneMania;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetChangeListener;
import org.genemania.plugin.data.IDataSetFactory;
import org.genemania.util.ProgressReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DataSetManager {
    public static final String DATA_FILE_NAME = "genemania.xml";
    protected static final String LAST_DATA_SET = "last_data_set";
    private final Map<String, IDataSetFactory> factories = new HashMap<String, IDataSetFactory>();
    protected final List<DataSetChangeListener> dataSetListeners = new ArrayList<DataSetChangeListener>();
    protected DataSet dataSet;
    protected File dataSourcePath;

    public void addDataSetFactory(IDataSetFactory factory, Map<?, ?> serviceProperties) {
        this.factories.put(factory.getId(), factory);
    }

    public void removeDataSetFactory(IDataSetFactory factory, Map<?, ?> serviceProperties) {
        this.factories.remove(factory.getId());
    }

    public IDataSetFactory getFactory(String id) {
        return this.factories.get(id);
    }

    public DataSet open(File path) throws SAXException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String configPath = this.getFullPath(path.getPath(), DATA_FILE_NAME);
            File file = new File(configPath);
            Document document = builder.parse(file.toURI().toString());
            Element root = document.getDocumentElement();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            String type = DataSetManager.getString(xpath, "type", root);
            IDataSetFactory dataSetFactory = this.getFactory(type);
            return dataSetFactory.create(path, root);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        catch (XPathExpressionException e) {
            throw new SAXException(e);
        }
        catch (SecurityException e) {
            throw new SAXException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SAXException(e);
        }
    }

    public boolean isDataSet(File file) {
        File config = new File(this.getFullPath(file.getPath(), DATA_FILE_NAME));
        return config.isFile();
    }

    String getFullPath(String base, String path) {
        return String.format("%s%s%s", base, File.separator, path);
    }

    protected static String getString(XPath xpath, String query, Node root) throws XPathExpressionException {
        String value = (String)xpath.evaluate(query, root, XPathConstants.STRING);
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    public void setDataSet(DataSet data, ProgressReporter progress) {
        SoftRefObjectCache.instance().clear();
        this.dataSet = data;
        this.notifyDataSetListeners(progress);
        File path = data != null ? new File(data.getBasePath()) : null;
        this.setDataSourcePath(path);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDataSourcePath() {
        DataSetManager dataSetManager = this;
        synchronized (dataSetManager) {
            return this.dataSourcePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSourcePath(File path) {
        DataSetManager dataSetManager = this;
        synchronized (dataSetManager) {
            this.dataSourcePath = path;
            File settingsDirectory = AbstractGeneMania.getSettingsDirectory();
            String lastDataSet = String.format("%s%s%s", settingsDirectory.getPath(), File.separator, LAST_DATA_SET);
            try {
                if (path == null) {
                    new File(lastDataSet).delete();
                    return;
                }
                FileWriter writer = new FileWriter(lastDataSet);
                try {
                    writer.write(path.getPath());
                    writer.write("\n");
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                LogUtils.log(this.getClass(), e);
            }
        }
    }

    public List<File> getDataSetPaths() {
        LinkedList<File> paths = new LinkedList<File>();
        File mostRecent = this.getMostRecentDataSetFile();
        File root = AbstractGeneMania.getSettingsDirectory();
        for (File file : root.listFiles()) {
            if (!file.isDirectory() || mostRecent != null && file.equals(mostRecent) || !this.isDataSet(file)) continue;
            paths.add(file);
        }
        Collections.sort(paths, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return (int)(o1.lastModified() - o2.lastModified());
            }
        });
        if (mostRecent != null) {
            paths.add(0, mostRecent);
        }
        return paths;
    }

    public File getDataSetPath(String dataSetName) {
        File mostRecent = this.getMostRecentDataSetFile();
        File root = AbstractGeneMania.getSettingsDirectory();
        for (File file : root.listFiles()) {
            String name;
            if (!file.isDirectory() || mostRecent != null && file.equals(mostRecent) || !this.isDataSet(file) || !(name = file.getName()).equals(dataSetName)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getMostRecentDataSetFile() {
        try {
            File file = AbstractGeneMania.getSettingsDirectory();
            String path = String.format("%s%s%s", file.getPath(), File.separator, LAST_DATA_SET);
            BufferedReader reader = new BufferedReader(new FileReader(path));
            try {
                String dataSetPath = reader.readLine();
                if (dataSetPath == null) {
                    File file2 = null;
                    return file2;
                }
                File dataSet = new File(dataSetPath);
                if (dataSet.isDirectory()) {
                    File file3 = dataSet;
                    return file3;
                }
                File file4 = null;
                return file4;
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public void reloadDataSet(ProgressReporter progress) {
        if (this.dataSet == null) {
            return;
        }
        try {
            this.dataSet.reload(progress);
            this.notifyDataSetListeners(progress);
        }
        catch (IOException e) {
            this.dataSet.log(e);
        }
    }

    void notifyDataSetListeners(ProgressReporter progress) {
        for (DataSetChangeListener listener : this.dataSetListeners) {
            listener.dataSetChanged(this.dataSet, progress);
        }
    }

    public void addDataSetChangeListener(DataSetChangeListener listener) {
        this.dataSetListeners.add(listener);
    }

    public void removeDataSetChangeListener(DataSetChangeListener listener) {
        this.dataSetListeners.remove(listener);
    }
}

