/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.compatibility;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.genemania.engine.cache.FileSerializedObjectCache;
import org.genemania.plugin.data.compatibility.AdapterStrategy;
import org.genemania.plugin.data.compatibility.AdaptingObjectInputStream;

public class AdapterStrategyObjectCache
extends FileSerializedObjectCache {
    List<AdapterStrategy> strategies;
    private boolean zipEnabled;

    public AdapterStrategyObjectCache(String cacheDir) {
        this(cacheDir, false);
    }

    public AdapterStrategyObjectCache(String cacheDir, boolean zipEnabled) {
        super(cacheDir, zipEnabled);
        this.zipEnabled = zipEnabled;
        this.strategies = new ArrayList<AdapterStrategy>();
    }

    public void addStrategy(AdapterStrategy strategy) {
        this.strategies.add(strategy);
    }

    protected Object deserialize(String filename) throws IOException, ClassNotFoundException {
        try {
            return new ObjectInputStream(this.createInputStream(filename)).readObject();
        }
        catch (InvalidClassException e) {
            return this.readObject(filename);
        }
    }

    private Object readObject(String path) throws IOException {
        for (AdapterStrategy strategy : this.strategies) {
            try {
                return new AdaptingObjectInputStream(this.createInputStream(path), strategy).readObject();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InvalidClassException e) {
                e.printStackTrace();
            }
        }
        throw new IOException("Unable to deserialize " + path);
    }

    private InputStream createInputStream(String path) throws IOException {
        FilterInputStream stream = new BufferedInputStream(new FileInputStream(path));
        if (this.zipEnabled) {
            stream = new GZIPInputStream(stream);
        }
        return stream;
    }
}

