/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.lucene.view.AbstractEditDialog;
import org.genemania.plugin.validation.OrganismValidator;
import org.genemania.plugin.view.util.UiUtils;

public class EditOrganismDialog
extends AbstractEditDialog {
    private final JTextField nameField;
    private final JTextField aliasField;
    private final JTextField taxIdField;
    private final JTextArea descriptionField;
    private final OrganismValidator validator;

    public EditOrganismDialog(Frame frame, boolean modality, UiUtils uiUtils, OrganismValidator validator) {
        super(frame, Strings.editOrganism_title, modality);
        this.validator = validator;
        JPanel contents = uiUtils.createJPanel();
        contents.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        contents.setLayout(new GridBagLayout());
        DocumentListener listener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditOrganismDialog.this.validateSettings();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditOrganismDialog.this.validateSettings();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditOrganismDialog.this.validateSettings();
            }
        };
        Insets insets = new Insets(0, 0, 0, 0);
        int row = 0;
        this.nameField = new JTextField(30);
        this.nameField.getDocument().addDocumentListener(listener);
        contents.add((Component)new JLabel(Strings.importOrganismName_label), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        contents.add((Component)this.nameField, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.aliasField = new JTextField(30);
        this.aliasField.getDocument().addDocumentListener(listener);
        contents.add((Component)new JLabel(Strings.importOrganismAlias_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        contents.add((Component)this.aliasField, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.taxIdField = new JTextField(30);
        this.taxIdField.getDocument().addDocumentListener(listener);
        contents.add((Component)new JLabel(Strings.importOrganismTaxonomyId_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        contents.add((Component)this.taxIdField, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.descriptionField = new JTextArea();
        this.descriptionField.getDocument().addDocumentListener(listener);
        contents.add((Component)new JLabel(Strings.importOrganismDescription_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 24, 0, insets, 0, 0));
        contents.add((Component)new JScrollPane(this.descriptionField), new GridBagConstraints(1, row, 2, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        JPanel buttonPanel = this.createButtonPanel(uiUtils);
        contents.add((Component)buttonPanel, new GridBagConstraints(0, ++row, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        ++row;
        this.setLayout(new GridBagLayout());
        this.add((Component)contents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setDescription(String description) {
        this.descriptionField.setText(description);
    }

    @Override
    protected boolean isValidForm() {
        boolean isValid = true;
        isValid &= this.validator.isValidName(this.nameField.getText());
        isValid &= this.validator.isValidAlias(this.aliasField.getText());
        return isValid &= this.validator.isValidTaxonomyId(this.taxIdField.getText());
    }

    public void setOrganismName(String name) {
        this.nameField.setText(name);
    }

    public String getOrganismName() {
        return this.nameField.getText();
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public void setAlias(String alias) {
        this.aliasField.setText(alias);
    }

    public void setTaxonomyId(long taxonomyId) {
        this.taxIdField.setText(String.valueOf(taxonomyId));
    }

    public String getAlias() {
        return this.aliasField.getText();
    }

    public long getTaxonomyId() {
        return Long.parseLong(this.taxIdField.getText());
    }
}

