/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.formatters;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.genemania.domain.Gene;
import org.genemania.plugin.controllers.IGeneProvider;
import org.genemania.plugin.formatters.IOutputFormatter;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;

public class GeneListOutputFormatter
implements IOutputFormatter {
    protected final IGeneProvider provider;

    public GeneListOutputFormatter(IGeneProvider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(OutputStream out, ViewState viewState) {
        SearchResult result = viewState.getSearchResult();
        PrintWriter writer = new PrintWriter(out);
        try {
            final Map<Gene, Double> scores = result.getScores();
            ArrayList<Gene> genes = new ArrayList<Gene>(scores.keySet());
            Collections.sort(genes, new Comparator<Gene>(){

                @Override
                public int compare(Gene gene1, Gene gene2) {
                    return -Double.compare((Double)scores.get(gene1), (Double)scores.get(gene2));
                }
            });
            for (Gene gene : genes) {
                this.formatGene(writer, result, gene, scores.get(gene));
            }
        }
        finally {
            writer.close();
        }
    }

    protected void formatGene(PrintWriter writer, SearchResult result, Gene gene, Double double1) {
        if (result.isQueryNode(gene.getNode().getId())) {
            writer.println(gene.getSymbol());
        } else {
            Gene preferredGene = this.provider.getGene(gene.getNode());
            writer.println(preferredGene.getSymbol());
        }
    }

    @Override
    public String getExtension() {
        return "genes.txt";
    }
}

