/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.model;

import java.util.Comparator;
import org.genemania.plugin.formatters.IObjectFormatter;

public class ModelElement<T>
implements Comparable<ModelElement<T>> {
    private final T item;
    private final Comparator<T> comparator;
    private final IObjectFormatter<T> formatter;

    public ModelElement(T item, Comparator<T> comparator, IObjectFormatter<T> formatter) {
        this.item = item;
        this.comparator = comparator;
        this.formatter = formatter;
    }

    public T getItem() {
        return this.item;
    }

    public String toString() {
        if (this.formatter == null) {
            return this.item.toString();
        }
        return this.formatter.format(this.item);
    }

    @Override
    public int compareTo(ModelElement<T> o) {
        return this.comparator.compare(this.item, o.getItem());
    }
}

