/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.plugin.model.AnnotationEntry;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.SearchResultBuilder;
import org.genemania.type.CombiningMethod;

public class SearchResultImpl
implements SearchResultBuilder {
    private Organism organism;
    private Map<Long, Gene> queryGenes;
    private Map<Long, InteractionNetworkGroup> groupsByNetwork;
    private Map<Long, AttributeGroup> groupsByAttribute;
    private Map<InteractionNetwork, Double> networkWeights;
    private Map<Attribute, Double> attributeWeights;
    private Map<Gene, Double> geneScores;
    private Map<Long, Collection<Attribute>> attributesByNode;
    private Map<Long, Collection<AnnotationEntry>> annotationsByNode;
    private Map<String, Collection<Gene>> genesByAnnotation;
    private Map<String, AnnotationEntry> categories = Collections.emptyMap();
    private Map<Long, Gene> genesByNodeId;
    private Map<String, InteractionNetworkGroup> groupsByName;
    private int geneSearchLimit;
    private int attributeSearchLimit;
    private CombiningMethod combiningMethod;

    public SearchResultImpl() {
        this.genesByAnnotation = Collections.emptyMap();
        this.annotationsByNode = Collections.emptyMap();
        this.attributesByNode = Collections.emptyMap();
        this.groupsByAttribute = Collections.emptyMap();
    }

    @Override
    public int getGeneSearchLimit() {
        return this.geneSearchLimit;
    }

    @Override
    public int getAttributeSearchLimit() {
        return this.attributeSearchLimit;
    }

    @Override
    public CombiningMethod getCombiningMethod() {
        return this.combiningMethod;
    }

    @Override
    public Organism getOrganism() {
        return this.organism;
    }

    @Override
    public Map<InteractionNetwork, Double> getNetworkWeights() {
        return this.networkWeights;
    }

    @Override
    public Map<Attribute, Double> getAttributeWeights() {
        return this.attributeWeights;
    }

    @Override
    public Map<Long, Collection<Attribute>> getAttributesByNodeId() {
        return this.attributesByNode;
    }

    @Override
    public Collection<Attribute> getAttributes(long nodeId) {
        return this.attributesByNode.get(nodeId);
    }

    @Override
    public AttributeGroup getAttributeGroup(long attributeId) {
        return this.groupsByAttribute.get(attributeId);
    }

    @Override
    public List<AnnotationEntry> getEnrichmentSummary() {
        ArrayList<AnnotationEntry> result = new ArrayList<AnnotationEntry>(this.categories.values());
        Collections.sort(result, new Comparator<AnnotationEntry>(){

            @Override
            public int compare(AnnotationEntry o1, AnnotationEntry o2) {
                return Double.compare(o1.getQValue(), o2.getQValue());
            }
        });
        return result;
    }

    @Override
    public Map<Long, Gene> getQueryGenes() {
        return this.queryGenes;
    }

    @Override
    public InteractionNetworkGroup getInteractionNetworkGroup(long networkId) {
        return this.groupsByNetwork.get(networkId);
    }

    @Override
    public Map<Long, InteractionNetworkGroup> getInteractionNetworkGroups() {
        return this.groupsByNetwork;
    }

    @Override
    public boolean isQueryNode(long nodeId) {
        return this.queryGenes.containsKey(nodeId);
    }

    @Override
    public Gene getGene(long nodeId) {
        return this.genesByNodeId.get(nodeId);
    }

    @Override
    public Map<Gene, Double> getScores() {
        return this.geneScores;
    }

    @Override
    public Collection<Gene> getNodesByAnnotation(String categoryName) {
        return this.genesByAnnotation.get(categoryName);
    }

    @Override
    public Collection<AnnotationEntry> getAnnotations(long nodeId) {
        return this.annotationsByNode.get(nodeId);
    }

    @Override
    public SearchResult build() {
        return this;
    }

    @Override
    public void setOrganism(Organism organism) {
        this.organism = organism;
    }

    @Override
    public void setSearchQuery(Map<Long, Gene> queryGenes) {
        this.queryGenes = queryGenes;
    }

    @Override
    public void setNetworkWeights(Map<InteractionNetwork, Double> networkWeights) {
        this.networkWeights = networkWeights;
    }

    @Override
    public void setGeneScores(Map<Gene, Double> geneScores) {
        this.geneScores = geneScores;
        this.genesByNodeId = new HashMap<Long, Gene>();
        for (Gene gene : geneScores.keySet()) {
            this.genesByNodeId.put(gene.getNode().getId(), gene);
        }
    }

    @Override
    public void setGroups(Map<Long, InteractionNetworkGroup> groupsByNetwork) {
        this.groupsByNetwork = groupsByNetwork;
        this.groupsByName = new HashMap<String, InteractionNetworkGroup>();
        for (InteractionNetworkGroup group : groupsByNetwork.values()) {
            this.groupsByName.put(group.getName(), group);
        }
    }

    @Override
    public void setEnrichment(Map<Long, Collection<AnnotationEntry>> enrichment) {
        this.annotationsByNode = enrichment;
        this.categories = new HashMap<String, AnnotationEntry>();
        this.genesByAnnotation = new HashMap<String, Collection<Gene>>();
        for (Map.Entry<Long, Collection<AnnotationEntry>> entry : enrichment.entrySet()) {
            long nodeId = entry.getKey();
            Collection<AnnotationEntry> annotations = entry.getValue();
            for (AnnotationEntry annotation : annotations) {
                String name = annotation.getName();
                this.categories.put(name, annotation);
                Collection<Gene> genes = this.genesByAnnotation.get(name);
                if (genes == null) {
                    genes = new HashSet<Gene>();
                    this.genesByAnnotation.put(name, genes);
                }
                Gene gene = this.genesByNodeId.get(nodeId);
                genes.add(gene);
            }
        }
    }

    @Override
    public void setAttributes(Map<Long, Collection<Attribute>> attributesByNode) {
        this.attributesByNode = attributesByNode;
    }

    @Override
    public void setGroupsByAttribute(Map<Long, AttributeGroup> groupsByAttribute) {
        this.groupsByAttribute = groupsByAttribute;
    }

    @Override
    public void setCombiningMethod(CombiningMethod combiningMethod) {
        this.combiningMethod = combiningMethod;
    }

    @Override
    public void setGeneSearchLimit(int geneSearchLimit) {
        this.geneSearchLimit = geneSearchLimit;
    }

    @Override
    public void setAttributeSearchLimit(int limit) {
        this.attributeSearchLimit = limit;
    }

    @Override
    public void setAttributeWeights(Map<Attribute, Double> weights) {
        this.attributeWeights = weights;
    }
}

