/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.parsers;

import java.util.List;
import org.genemania.domain.Organism;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.OrganismMediator;
import org.genemania.plugin.apps.IQueryErrorHandler;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.parsers.IQueryParser;
import org.genemania.plugin.parsers.Query;
import org.genemania.type.CombiningMethod;

public abstract class AbstractQueryParser
implements IQueryParser {
    protected static String[] preferredGroupCodes = new String[]{"coexp", "pi", "gi"};

    protected CombiningMethod parseCombiningMethod(String combiningMethod, Query query, IQueryErrorHandler handler) {
        if (combiningMethod == null) {
            CombiningMethod method = CombiningMethod.AUTOMATIC_SELECT;
            return method;
        }
        CombiningMethod method = CombiningMethod.fromCode((String)combiningMethod);
        if (method == CombiningMethod.UNKNOWN) {
            method = CombiningMethod.AUTOMATIC;
            handler.warn(String.format("Unrecognized combining method \"%s\".  Defaulting to: %s", combiningMethod, method));
        }
        return method;
    }

    public Organism parseOrganism(DataSet data, String name) throws DataStoreException {
        String filtered = name.toLowerCase();
        OrganismMediator mediator = data.getMediatorProvider().getOrganismMediator();
        List organisms = mediator.getAllOrganisms();
        Long taxonId = null;
        try {
            taxonId = Long.parseLong(name);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (Organism organism : organisms) {
            if (taxonId != null && taxonId.longValue() == organism.getTaxonomyId()) {
                return organism;
            }
            String organismName = organism.getName();
            if (organismName != null && organismName.toLowerCase().equals(filtered)) {
                return organism;
            }
            String organismAlias = organism.getAlias();
            if (organismAlias == null || !organismAlias.toLowerCase().equals(filtered)) continue;
            return organism;
        }
        return null;
    }
}

