/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.AttributeMediator;
import org.genemania.plugin.apps.IQueryErrorHandler;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.impl.InteractionNetworkGroupImpl;
import org.genemania.plugin.model.impl.InteractionNetworkImpl;
import org.genemania.plugin.model.impl.QueryAttributeGroupImpl;
import org.genemania.plugin.model.impl.QueryAttributeNetworkImpl;
import org.genemania.plugin.parsers.AbstractQueryParser;
import org.genemania.plugin.parsers.Query;

public class TabDelimitedQueryParser
extends AbstractQueryParser {
    @Override
    public Query parse(DataSet data, Reader reader, IQueryErrorHandler handler) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        try {
            Query query = new Query();
            String organismData = in.readLine();
            String filtered = organismData.toLowerCase();
            Organism organism = this.parseOrganism(data, filtered);
            if (organism == null) {
                throw new IOException(String.format("Cannot find organism: %s", organismData));
            }
            query.setOrganism(organism);
            List<String> genes = this.parseGenes(in.readLine());
            query.setGenes(genes);
            String networkData = in.readLine();
            AttributeMediator attributeMediator = data.getMediatorProvider().getAttributeMediator();
            Collection<Group<?, ?>> groups = this.parseNetworks(networkData, organism, "\t", handler, attributeMediator);
            if (groups.size() == 0) {
                throw new IOException(String.format("Unrecognized network(s): %s", networkData));
            }
            for (Group<?, ?> group : groups) {
                Group<InteractionNetworkGroup, InteractionNetwork> adapted = group.adapt(InteractionNetworkGroup.class, InteractionNetwork.class);
                if (adapted == null) continue;
                for (Network<InteractionNetwork> network : adapted.getNetworks()) {
                    handler.handleNetwork(network.getModel());
                }
            }
            query.setNetworks(groups);
            String limits = in.readLine();
            this.setLimits(query, limits);
            String combiningMethod = in.readLine();
            HashSet<Long> nodes = new HashSet<Long>();
            GeneCompletionProvider2 provider = data.getCompletionProvider(organism);
            for (String gene : genes) {
                Long nodeId = provider.getNodeId(gene);
                if (nodeId == null) {
                    handler.handleUnrecognizedGene(gene);
                    continue;
                }
                if (nodes.contains(nodeId)) {
                    handler.handleSynonym(gene);
                    continue;
                }
                nodes.add(nodeId);
            }
            if (nodes.size() == 0) {
                throw new IOException("None of your query genes were recognized");
            }
            query.setNodes(nodes);
            query.setCombiningMethod(this.parseCombiningMethod(combiningMethod, query, handler));
            Query query2 = query;
            return query2;
        }
        catch (DataStoreException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            in.close();
        }
    }

    private void setLimits(Query query, String limits) {
        Pattern pattern = Pattern.compile("(\\d+)(\t(\\d+))?");
        Matcher matcher = pattern.matcher(limits);
        if (matcher.matches()) {
            String attributeLimit;
            String geneLimit = matcher.group(1);
            if (geneLimit != null) {
                query.setGeneLimit(Integer.parseInt(geneLimit));
            }
            if ((attributeLimit = matcher.group(3)) != null) {
                query.setAttributeLimit(Integer.parseInt(attributeLimit));
            }
        }
    }

    protected List<String> parseGenes(String data) {
        String[] genes = data.split("\t");
        return Arrays.asList(genes);
    }

    public Collection<Group<?, ?>> parseNetworks(String networkData, Organism organism, String delimiter, IQueryErrorHandler handler, AttributeMediator attributeMediator) {
        if (networkData == null) {
            return Collections.emptyList();
        }
        HashSet<String> types = new HashSet<String>();
        HashSet<Long> networkIds = new HashSet<Long>();
        boolean useDefaults = false;
        boolean useAll = false;
        boolean useAllAttributes = false;
        HashSet<String> notHandled = new HashSet<String>();
        for (String item : networkData.split(delimiter)) {
            item = item.trim();
            types.add(item);
            notHandled.add(item);
            try {
                networkIds.add(Long.parseLong(item));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (item.equalsIgnoreCase("default")) {
                useDefaults = true;
                continue;
            }
            if (item.equalsIgnoreCase("preferred")) {
                types.addAll(Arrays.asList(preferredGroupCodes));
                continue;
            }
            if (item.equalsIgnoreCase("all")) {
                useAll = true;
                continue;
            }
            if (!item.equalsIgnoreCase("Attributes")) continue;
            useAllAttributes = true;
        }
        notHandled.remove("default");
        notHandled.remove("preferred");
        notHandled.remove("all");
        notHandled.remove("Attributes");
        HashSet groupMembers = new HashSet();
        Collection groups = organism.getInteractionNetworkGroups();
        for (InteractionNetworkGroup group : groups) {
            boolean useGroupName;
            ArrayList<Network<InteractionNetwork>> networkMembers = new ArrayList<Network<InteractionNetwork>>();
            boolean useGroupCode = types.contains(group.getCode());
            if (useGroupCode) {
                notHandled.remove(group.getCode());
            }
            if (useGroupName = types.contains(group.getName())) {
                notHandled.remove(group.getName());
            }
            Collection networks = group.getInteractionNetworks();
            for (InteractionNetwork network : networks) {
                boolean useNetworkId;
                boolean useNetworkName;
                boolean useKey;
                String key = this.findGroupAndNetworkKey(group, network, types);
                boolean bl = useKey = key != null;
                if (useKey) {
                    notHandled.remove(key);
                }
                if (useNetworkName = types.contains(network.getName())) {
                    notHandled.remove(network.getName());
                }
                if (useNetworkId = networkIds.contains(network.getId())) {
                    notHandled.remove(String.valueOf(network.getId()));
                }
                if (!useAll && !useGroupCode && !useGroupName && !useNetworkId && !useNetworkName && !useKey && (!useDefaults || !network.isDefaultSelected())) continue;
                networkMembers.add(new InteractionNetworkImpl(network, 0.0));
            }
            if (networkMembers.size() <= 0) continue;
            groupMembers.add(new InteractionNetworkGroupImpl(group, networkMembers));
        }
        ArrayList<Network<AttributeGroup>> networkMembers = new ArrayList<Network<AttributeGroup>>();
        for (AttributeGroup group : attributeMediator.findAttributeGroupsByOrganism(organism.getId())) {
            boolean useGroupCode;
            boolean useGroupName;
            boolean useKey;
            String key = this.findKey(group, types);
            boolean bl = useKey = key != null;
            if (useKey) {
                notHandled.remove(key);
            }
            if (useGroupName = types.contains(group.getName())) {
                notHandled.remove(group.getName());
            }
            if (useGroupCode = types.contains(group.getCode())) {
                notHandled.remove(group.getCode());
            }
            if (!useAll && !useGroupCode && !useGroupName && !useKey && !useAllAttributes) continue;
            networkMembers.add(new QueryAttributeNetworkImpl(group, 0.0));
        }
        if (networkMembers.size() > 0) {
            groupMembers.add(new QueryAttributeGroupImpl((Collection<Network<AttributeGroup>>)networkMembers));
        }
        for (String item : notHandled) {
            handler.handleUnrecognizedNetwork(item);
        }
        return groupMembers;
    }

    private String findKey(AttributeGroup group, Set<String> types) {
        String[] groupNames;
        for (String groupName : groupNames = new String[]{group.getCode(), group.getName()}) {
            String key = String.format("Attributes|%s", groupName);
            if (!types.contains(key)) continue;
            return key;
        }
        return null;
    }

    private String findGroupAndNetworkKey(InteractionNetworkGroup group, InteractionNetwork network, Set<String> types) {
        String[] groupNames;
        for (String groupName : groupNames = new String[]{group.getCode(), group.getName()}) {
            String key = String.format("%s|%s", groupName, network.getName());
            if (!types.contains(key)) continue;
            return key;
        }
        return null;
    }
}

