/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import org.genemania.plugin.view.util.UiUtils;

public class TextReportDialog<T>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Map<String, T> values;
    private String selectedOption;
    private final UiUtils uiUtils;

    public TextReportDialog(Dialog parent, String message, List<String> options, Map<String, T> values, String report, boolean modal, UiUtils uiUtils) {
        super(parent, modal);
        this.uiUtils = uiUtils;
        this.initialize(message, options, values, report);
    }

    public TextReportDialog(Frame parent, String message, List<String> options, Map<String, T> values, String report, boolean modal, UiUtils uiUtils) {
        super(parent, modal);
        this.uiUtils = uiUtils;
        this.initialize(message, options, values, report);
    }

    private void initialize(String message, List<String> options, Map<String, T> values, String report) {
        this.values = values;
        JRootPane root = this.getRootPane();
        root.setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        JEditorPane reportPane = this.uiUtils.createEditorPane(report);
        reportPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(reportPane);
        root.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        JLabel label = new JLabel(message);
        root.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        JPanel buttonPanel = this.createButtonPanel(root, options);
        root.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.setLocationByPlatform(true);
        this.pack();
    }

    private JPanel createButtonPanel(JComponent component, List<String> options) {
        JPanel buttonPanel = this.uiUtils.createJPanel();
        buttonPanel.setLayout(new FlowLayout());
        for (final String label : options) {
            JButton button = new JButton(label);
            final TextReportDialog dialog = this;
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextReportDialog.this.selectedOption = label;
                    dialog.setVisible(false);
                }
            });
            buttonPanel.add(button);
        }
        return buttonPanel;
    }

    public T getSelectedValue() {
        if (this.selectedOption == null) {
            return null;
        }
        return this.values.get(this.selectedOption);
    }
}

