/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.plugin.Strings;
import org.genemania.plugin.view.util.UiUtils;

public class NetworkGroupWidget {
    private final JPanel panel;
    private final Map<InteractionNetwork, JCheckBox> networkMap = new HashMap<InteractionNetwork, JCheckBox>();
    private final JCheckBox groupCheckBox;
    private final String groupName;
    private final List<ActionListener> listeners = new LinkedList<ActionListener>();

    public NetworkGroupWidget(InteractionNetworkGroup group, List<InteractionNetwork> networks, UiUtils uiUtils) {
        this.panel = uiUtils.createJPanel();
        this.panel.setLayout(new GridBagLayout());
        final JToggleButton expander = uiUtils.createToggleButton();
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.panel.add((Component)expander, constraints);
        this.groupName = group.getName();
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.groupCheckBox = uiUtils.createCheckBox(this.groupName);
        this.groupCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkGroupWidget.this.handleGroupCheckBoxAction(e);
            }
        });
        this.panel.add((Component)this.groupCheckBox, constraints);
        final JPanel groupContents = uiUtils.createJPanel();
        groupContents.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.panel.add((Component)groupContents, constraints);
        groupContents.setVisible(false);
        expander.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                groupContents.setVisible(expander.isSelected());
            }
        });
        int networkIndex = 0;
        for (InteractionNetwork network : networks) {
            JCheckBox checkBox = uiUtils.createCheckBox(network.getName());
            checkBox.setSelected(network.isDefaultSelected());
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkGroupWidget.this.synchronizeCheckState();
                }
            });
            constraints = new GridBagConstraints(0, networkIndex, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 24, 0, 0), 0, 0);
            groupContents.add((Component)checkBox, constraints);
            this.networkMap.put(network, checkBox);
            ++networkIndex;
        }
        this.synchronizeCheckState();
    }

    private void handleGroupCheckBoxAction(ActionEvent e) {
        int totalSelected = this.countSelectedNetworks();
        boolean newState = totalSelected < this.networkMap.size();
        this.groupCheckBox.setSelected(newState);
        for (JCheckBox checkBox : this.networkMap.values()) {
            checkBox.setSelected(newState);
        }
        this.updateLabel(newState ? this.networkMap.size() : 0);
        this.notifyListeners(e);
    }

    private void notifyListeners(ActionEvent e) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(e);
        }
    }

    private void synchronizeCheckState() {
        int totalSelected = this.countSelectedNetworks();
        this.groupCheckBox.setSelected(totalSelected > 0);
        this.updateLabel(totalSelected);
    }

    private void updateLabel(int totalSelected) {
        this.groupCheckBox.setText(String.format(Strings.detailedSelection_label, this.groupName, totalSelected, this.networkMap.size()));
    }

    private int countSelectedNetworks() {
        int totalTrue = 0;
        for (JCheckBox checkBox : this.networkMap.values()) {
            if (!checkBox.isSelected()) continue;
            ++totalTrue;
        }
        return totalTrue;
    }

    public Component getComponent() {
        return this.panel;
    }

    public Map<InteractionNetwork, JCheckBox> getCheckBoxes() {
        return Collections.unmodifiableMap(this.networkMap);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
        for (JCheckBox checkBox : this.networkMap.values()) {
            checkBox.addActionListener(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
        for (JCheckBox checkBox : this.networkMap.values()) {
            checkBox.removeActionListener(listener);
        }
    }
}

