/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import java.util.ArrayList;
import org.genemania.dto.ListAttributeGroupsEngineRequestDto;
import org.genemania.dto.ListAttributeGroupsEngineResponseDto;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.exception.ApplicationException;

public class ListAttributeGroups {
    DataCache cache;
    ListAttributeGroupsEngineRequestDto request;

    public ListAttributeGroups(DataCache cache, ListAttributeGroupsEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public ListAttributeGroupsEngineResponseDto process() throws ApplicationException {
        if (this.request.getNamespace() == null) {
            throw new ApplicationException("no namespace given");
        }
        if (this.request.getOrganismId() == 0L) {
            throw new ApplicationException("no organism id specified, but don't know how to list all organisms. yet.");
        }
        AttributeGroups data = this.cache.getAttributeGroups(this.request.getNamespace(), this.request.getOrganismId());
        data.getAttributeGroups();
        ListAttributeGroupsEngineResponseDto response = new ListAttributeGroupsEngineResponseDto();
        ArrayList<Long> ids = new ArrayList<Long>(data.getAttributeGroups().keySet());
        response.setAttributeGroupIds(ids);
        return response;
    }
}

