/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import org.genemania.dto.RemoveAttributeGroupEngineRequestDto;
import org.genemania.dto.RemoveAttributeGroupEngineResponseDto;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.AttributeData;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.exception.ApplicationException;

public class RemoveAttributeGroup {
    DataCache cache;
    RemoveAttributeGroupEngineRequestDto request;

    public RemoveAttributeGroup(DataCache cache, RemoveAttributeGroupEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public RemoveAttributeGroupEngineResponseDto process() throws ApplicationException {
        if (this.request.getNamespace() == null) {
            throw new ApplicationException("no namepspace specified");
        }
        if (this.request.getOrganismId() == 0L) {
            throw new ApplicationException("no organism id specified, but don't know how to list all organisms. yet.");
        }
        if (this.request.getAttributeGroupId() > 0L) {
            throw new ApplicationException("can not remove core attribute group");
        }
        AttributeGroups groups = this.cache.getAttributeGroups(this.request.getNamespace(), this.request.getOrganismId());
        if (groups.getAttributeGroups().containsKey(this.request.getAttributeGroupId())) {
            groups.getAttributeGroups().remove(this.request.getAttributeGroupId());
            this.cache.putAttributeGroups(groups);
            this.cache.removeData(new AttributeData(this.request.getNamespace(), this.request.getOrganismId(), this.request.getAttributeGroupId()));
        }
        return new RemoveAttributeGroupEngineResponseDto();
    }
}

