/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.genemania.domain.Ontology;
import org.genemania.domain.OntologyCategory;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.apps.CacheBuilder;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.data.CategoryIds;
import org.genemania.engine.core.data.GoAnnotations;
import org.genemania.engine.core.data.GoIds;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.matricks.Matrix;
import org.genemania.exception.ApplicationException;
import org.kohsuke.args4j.Option;

public class AnnotationSlimmer
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(CacheBuilder.class);
    @Option(name="-pondir", usage="processed ontologies dir")
    String pondir;
    @Option(name="-orgId", usage="optional organism id, otherwise will process all oganisms")
    private long orgId = -1L;
    GoAnnotations annos;
    GoIds goIds;
    CategoryIds catIds;

    public String getPondir() {
        return this.pondir;
    }

    public void setPondir(String pondir) {
        this.pondir = pondir;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public void logParams() {
        logger.info((Object)("cache dir: " + this.getCacheDir()));
        logger.info((Object)("processed ontologies dir: " + this.pondir));
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.logParams();
    }

    @Override
    public void process() throws Exception {
        if (this.orgId != -1L) {
            throw new ApplicationException("single organism processing not implemented");
        }
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            this.processOrganism(organism);
        }
    }

    public void processOrganism(Organism organism) throws Exception {
        Ontology ontology = organism.getOntology();
        if (ontology == null) {
            logger.warn((Object)String.format("No default ontology specified for %d (%s), skipping", organism.getId(), organism.getName()));
            return;
        }
        logger.info((Object)String.format("processing ontology %d (%s) for organism %d (%s)", ontology.getId(), ontology.getName(), organism.getId(), organism.getName()));
        this.allocEnrichmentDataStructures(organism);
        this.loadAnnos(organism, "ALL");
        this.write();
        this.log();
    }

    protected void allocEnrichmentDataStructures(Organism organism) throws ApplicationException {
        String ontologyName = organism.getOntology().getName();
        this.annos = new GoAnnotations(organism.getId(), "" + organism.getOntology().getId());
        int numCategories = organism.getOntology().getCategories().size();
        NodeIds nodeIds = this.cache.getNodeIds(organism.getId());
        int numGenes = nodeIds.getNodeIds().length;
        Matrix data = Config.instance().getMatrixFactory().sparseMatrix(numGenes, numCategories);
        this.annos.setData(data);
        this.goIds = new GoIds(organism.getId(), "" + organism.getOntology().getId());
        this.catIds = new CategoryIds(organism.getId(), organism.getOntology().getId());
        String[] catNames = new String[numCategories];
        long[] catIdList = new long[numCategories];
        Collection categories = organism.getOntology().getCategories();
        int i = 0;
        for (OntologyCategory category : categories) {
            catNames[i] = category.getName();
            catIdList[i] = category.getId();
            ++i;
        }
        this.goIds.setGoIds(catNames);
        this.catIds.setCategoryIds(catIdList);
    }

    protected void loadAnnos(Organism organism, String fromAnno) throws ApplicationException {
        GoAnnotations branchAnnos = this.cache.getGoAnnotations(organism.getId(), fromAnno);
        GoIds branchIds = this.cache.getGoIds(organism.getId(), fromAnno);
        String[] categoryNames = this.goIds.getGoIds();
        for (int i = 0; i < categoryNames.length; ++i) {
            String categoryName = categoryNames[i];
            try {
                int indexForCat = branchIds.getIndexForId(categoryName);
                this.copyRec(branchAnnos.getData(), indexForCat, this.annos.getData(), i);
                continue;
            }
            catch (ApplicationException e) {
                // empty catch block
            }
        }
    }

    protected void copyRec(Matrix from, int fromCol, Matrix to, int toCol) {
        int numRows = from.numRows();
        for (int i = 0; i < numRows; ++i) {
            double fromVal = from.get(i, fromCol);
            if (fromVal == 0.0) continue;
            to.set(i, toCol, fromVal);
        }
    }

    protected void write() throws ApplicationException {
        this.cache.putGoAnnotations(this.annos);
        this.cache.putGoIds(this.goIds);
        this.cache.putCategoryIds(this.catIds);
    }

    protected void log() throws ApplicationException {
        double[] annosPerCat = new double[this.annos.getData().numCols()];
        this.annos.getData().columnSums(annosPerCat);
        for (int catIndex = 0; catIndex < annosPerCat.length; ++catIndex) {
            logger.debug((Object)String.format("Category index %d, id %d, name %s, genes annotated %f", catIndex, this.catIds.getIdForIndex(catIndex), this.goIds.getIdForIndex(catIndex), annosPerCat[catIndex]));
        }
    }

    protected String getPonFilename(Organism organism) {
        return this.pondir + File.separator + organism.getOntology() + ".txt";
    }

    public static void main(String[] args) throws Exception {
        AnnotationSlimmer slimmer = new AnnotationSlimmer();
        if (!slimmer.getCommandLineArgs(args)) {
            System.exit(1);
        }
        try {
            slimmer.init();
            slimmer.process();
            slimmer.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }
}

