/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import org.apache.log4j.Logger;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.summary.IdentifiersSummarizer;
import org.genemania.engine.summary.NetworksSummarizer;
import org.genemania.engine.summary.OntologiesSummarizer;
import org.genemania.engine.summary.OrganismsSummarizer;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;
import org.genemania.engine.summary.TabularReporterFactory;
import org.kohsuke.args4j.Option;

public class DatasetSummarizer
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(DatasetSummarizer.class);
    @Option(name="-reportDir", usage="location of report directory")
    private String reportDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void summarize(Summarizer summarizer, ReporterFactory reporterFactory) throws Exception {
        summarizer.setUp();
        try {
            summarizer.summarize(reporterFactory);
        }
        finally {
            summarizer.tearDown();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    void summarizeOrganism(Organism organism) throws Exception {
        TabularReporterFactory reporterFactory = new TabularReporterFactory(this.reportDir + File.separator + organism.getId());
        Summarizer summarizer = null;
        summarizer = new OntologiesSummarizer(organism, this.dataConnector);
        this.summarize(summarizer, reporterFactory);
        summarizer = new IdentifiersSummarizer(organism, this.dataConnector);
        this.summarize(summarizer, reporterFactory);
        summarizer = new NetworksSummarizer(organism, this.dataConnector);
        this.summarize(summarizer, reporterFactory);
    }

    @Override
    public void process() throws Exception {
        OrganismsSummarizer summarizer = new OrganismsSummarizer(this.dataConnector);
        this.summarize(summarizer, new TabularReporterFactory(this.reportDir));
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            logger.info((Object)String.format("Organism %d: %s", organism.getId(), organism.getName()));
            this.summarizeOrganism(organism);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            DatasetSummarizer instance = new DatasetSummarizer();
            instance.getCommandLineArgs(args);
            instance.setupLogging();
            instance.init();
            instance.process();
            instance.cleanup();
            logger.info((Object)"summary report completed.");
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }
}

