/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.exception.ApplicationException;

public class FileSerializedObjectCache
implements IObjectCache {
    private String cacheDir;
    private boolean zipEnabled = false;

    @Override
    public String getCacheDir() {
        return this.cacheDir;
    }

    public FileSerializedObjectCache(String cacheDir, boolean zipEnabled) {
        this.cacheDir = cacheDir;
        this.zipEnabled = zipEnabled;
    }

    public FileSerializedObjectCache(String cacheDir) {
        this(cacheDir, false);
    }

    private String getFilename(String key) {
        String name = this.cacheDir + File.separator + key + ".ser";
        if (this.zipEnabled) {
            name = name + ".gz";
        }
        return name;
    }

    private String getFilename(String subdir, String key) {
        String name = this.cacheDir + File.separator + subdir + File.separator + key + ".ser";
        if (this.zipEnabled) {
            name = name + ".gz";
        }
        return name;
    }

    public String getFilename(String[] key) throws ApplicationException {
        if (key == null || key.length == 0) {
            throw new ApplicationException("empty key");
        }
        String name = this.getSubdirname(key, key.length) + ".ser";
        if (this.zipEnabled) {
            name = name + ".gz";
        }
        return name;
    }

    public String getSubdirname(String[] key, int len) throws ApplicationException {
        StringBuilder path = new StringBuilder(this.cacheDir);
        for (int i = 0; i < len; ++i) {
            path.append(File.separator);
            if (key[i] == null || key[i].equals("")) {
                throw new ApplicationException("missing key part at position " + i);
            }
            path.append(key[i]);
        }
        return path.toString();
    }

    private String[] fileToKey(File file) throws ApplicationException {
        if (!file.toString().startsWith(this.cacheDir)) {
            throw new ApplicationException("unexpected cache file name");
        }
        if (!file.toString().endsWith(".ser")) {
            throw new ApplicationException("unexpected cache file name");
        }
        String keyString = file.toString().substring(this.cacheDir.length() + 1, file.toString().length() - 4);
        return keyString.split(File.separator);
    }

    private String getDir(String subdir) {
        return this.cacheDir + File.separator + subdir;
    }

    private Object getObject(String subdir, String key) throws ApplicationException {
        Object value = null;
        try {
            String filename = subdir != null ? this.getFilename(subdir, key) : this.getFilename(key);
            InputStream fileIn = new FileInputStream(filename);
            fileIn = new BufferedInputStream(fileIn);
            if (this.zipEnabled) {
                fileIn = new GZIPInputStream(fileIn);
            }
            ObjectInputStream in = new ObjectInputStream(fileIn);
            value = in.readObject();
            in.close();
            fileIn.close();
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationException(String.format("Failed to load object with key: '%s' from path '%s'", key, subdir), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException(String.format("Failed to load object with key: '%s' from path '%s'", key, subdir), (Throwable)e);
        }
        catch (IOException e) {
            throw new ApplicationException(String.format("Failed to load object with key: '%s' from path '%s'", key, subdir), (Throwable)e);
        }
        return value;
    }

    private void checkCreateDir(String subdir) {
        String dirName = this.cacheDir + File.separator + subdir;
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
    }

    private void checkCreateDirs(String[] key) throws ApplicationException {
        String dirName = this.getSubdirname(key, key.length - 1);
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
    }

    private void checkDir(String subdir) throws ApplicationException {
        String dirName = this.cacheDir + File.separator + subdir;
        File dir = new File(dirName);
        if (!dir.exists()) {
            throw new ApplicationException("directory does not exist: " + dirName);
        }
        if (!dir.isDirectory()) {
            throw new ApplicationException("not a directory: " + dirName);
        }
    }

    public void putObject(String subdir, String key, Object value) throws ApplicationException {
        try {
            String filename;
            if (subdir != null) {
                this.checkCreateDir(subdir);
                filename = this.getFilename(subdir, key);
            } else {
                filename = this.getFilename(key);
            }
            FileOutputStream fileOut = new FileOutputStream(filename);
            FilterOutputStream out = new BufferedOutputStream(fileOut);
            if (this.zipEnabled) {
                out = new GZIPOutputStream(out);
            }
            ObjectOutputStream objout = new ObjectOutputStream(out);
            objout.writeObject(value);
            objout.flush();
            fileOut.getFD().sync();
            objout.close();
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException("Failed to save object with key: " + key, (Throwable)e);
        }
        catch (IOException e) {
            throw new ApplicationException("Failed to save object with key: " + key, (Throwable)e);
        }
    }

    @Override
    public void put(String[] key, Object value, boolean isVolatile) throws ApplicationException {
        try {
            this.checkCreateDirs(key);
            String filename = this.getFilename(key);
            FileOutputStream fileOut = new FileOutputStream(filename);
            FilterOutputStream out = new BufferedOutputStream(fileOut);
            if (this.zipEnabled) {
                out = new GZIPOutputStream(out);
            }
            ObjectOutputStream objout = new ObjectOutputStream(out);
            objout.writeObject(value);
            objout.flush();
            fileOut.getFD().sync();
            objout.close();
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException("Failed to save object with key: " + key, (Throwable)e);
        }
        catch (IOException e) {
            throw new ApplicationException("Failed to save object with key: " + key, (Throwable)e);
        }
    }

    @Override
    public Object get(String[] key, boolean isVolatile) throws ApplicationException {
        Object value = null;
        String filename = null;
        try {
            filename = this.getFilename(key);
            value = this.deserialize(filename);
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationException(String.format("Failed to load object with key: '%s'", filename), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException(String.format("Failed to load object with key: '%s'", filename), (Throwable)e);
        }
        catch (IOException e) {
            throw new ApplicationException(String.format("Failed to load object with key: '%s'", filename), (Throwable)e);
        }
        return value;
    }

    protected Object deserialize(String filename) throws IOException, ClassNotFoundException {
        InputStream fileIn = new FileInputStream(filename);
        fileIn = new BufferedInputStream(fileIn);
        if (this.zipEnabled) {
            fileIn = new GZIPInputStream(fileIn);
        }
        ObjectInputStream in = new ObjectInputStream(fileIn);
        Object value = in.readObject();
        in.close();
        fileIn.close();
        return value;
    }

    @Override
    public void remove(String[] key) throws ApplicationException {
        if (key == null || key.length == 0) {
            throw new ApplicationException("directory not given");
        }
        String filename = this.getFilename(key);
        File file = new File(filename);
        if (file.exists() && file.isFile()) {
            file.delete();
            return;
        }
        String dirName = this.getSubdirname(key, key.length);
        file = new File(dirName);
        if (file.isDirectory()) {
            FileSerializedObjectCache.recursiveDeleteDir(file);
        }
    }

    private static void recursiveDeleteDir(File dir) {
        File[] entries;
        for (File entry : entries = dir.listFiles()) {
            if (entry.isFile()) {
                entry.delete();
                continue;
            }
            if (!entry.isDirectory()) continue;
            FileSerializedObjectCache.recursiveDeleteDir(entry);
        }
        dir.delete();
    }

    @Override
    public boolean exists(String[] key) throws ApplicationException {
        if (key == null || key.length == 0) {
            throw new ApplicationException("null or empty object key");
        }
        String filename = this.getFilename(key);
        File file = new File(filename);
        return file.exists();
    }

    @Override
    public List<String[]> list(String[] key) throws ApplicationException {
        File[] entries;
        if (key == null || key.length == 0) {
            throw new ApplicationException("null or empty object key");
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        String dirName = this.getSubdirname(key, key.length);
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            return result;
        }
        for (File entry : entries = dir.listFiles()) {
            result.add(this.fileToKey(entry));
        }
        return result;
    }
}

