/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.converter;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.genemania.domain.Gene;
import org.genemania.domain.Organism;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.GeneMediator;

public class SymbolCache {
    private static Logger logger = Logger.getLogger(SymbolCache.class);
    private GeneMediator geneMediator;
    private Map<String, Integer> symbolToIndexCache = new HashMap<String, Integer>();
    private static final int SYMBOL_NOT_FOUND = -1;
    private Organism organism;
    private NodeIds nodeIds;

    public SymbolCache(Organism oragnism, GeneMediator geneMediator, DataCache cache) throws ApplicationException {
        this.organism = oragnism;
        this.geneMediator = geneMediator;
        this.nodeIds = cache.getNodeIds(this.organism.getId());
    }

    public Integer getIndexForSymbol(String symbol) {
        Integer index = this.symbolToIndexCache.get(symbol.toUpperCase());
        if (index == null) {
            Gene gene = this.geneMediator.getGeneForSymbol(this.organism, symbol);
            if (gene == null) {
                logger.info((Object)("symbol not in db: " + symbol));
                this.symbolToIndexCache.put(symbol.toUpperCase(), -1);
            } else {
                int nodeId = (int)gene.getNode().getId();
                try {
                    index = this.nodeIds.getIndexForId(nodeId);
                    this.symbolToIndexCache.put(symbol.toUpperCase(), index);
                }
                catch (ApplicationException e) {
                    logger.warn((Object)("gene not in mappings for " + gene.getSymbol()));
                    this.symbolToIndexCache.put(symbol.toUpperCase(), -1);
                    index = null;
                }
            }
        } else if (index == -1) {
            index = null;
        }
        return index;
    }
}

