/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.converter.sym;

import java.io.File;
import java.io.IOException;
import org.genemania.engine.converter.sym.CursorNetworkSymMatrixProvider;
import org.genemania.engine.converter.sym.INetworkSymMatrixProvider;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.impl.FileInteractionCursor;
import org.genemania.util.ProgressReporter;

public class FileNetworkSymMatrixProvider
extends CursorNetworkSymMatrixProvider
implements INetworkSymMatrixProvider {
    private long organismId;
    private String networkDir;
    private boolean isBinary;

    public FileNetworkSymMatrixProvider(long organismId, String networkDir, NodeIds nodeIds, boolean isBinary) {
        this.organismId = organismId;
        this.networkDir = networkDir;
        this.nodeIds = nodeIds;
        this.isBinary = isBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymMatrix getNetworkMatrix(long networkId, ProgressReporter progress) throws ApplicationException {
        File file;
        try {
            file = this.getFile(networkId);
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
        this.cursor = this.isBinary ? new FileInteractionCursor(networkId, file, "UTF8", 0, 1, -1, '\t') : new FileInteractionCursor(networkId, file, "UTF8", 0, 1, 2, '\t');
        try {
            SymMatrix symMatrix = this.convertNetworkToMatrix(progress);
            return symMatrix;
        }
        finally {
            this.cursor.close();
        }
    }

    private File getFile(long networkId) throws IOException {
        File file = new File(this.networkDir + File.separator + this.organismId + "." + networkId + ".txt.gz");
        if (file.exists()) {
            return file;
        }
        return new File(this.networkDir + File.separator + this.organismId + "." + networkId + ".txt");
    }
}

