/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import org.genemania.engine.core.data.Data;
import org.genemania.exception.ApplicationException;

public class AttributeGroups
extends Data {
    private static final long serialVersionUID = 36730522635636429L;
    private HashMap<Long, ArrayList<Long>> attributeGroups;
    private HashMap<Long, Long> reverseMap;

    public AttributeGroups(String namespace, long organismId) {
        super(namespace, organismId);
    }

    public HashMap<Long, ArrayList<Long>> getAttributeGroups() {
        return this.attributeGroups;
    }

    public void setAttributeGroups(HashMap<Long, ArrayList<Long>> attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    @Override
    public String[] getKey() {
        return new String[]{this.getNamespace(), "" + this.getOrganismId(), "attributeGroups"};
    }

    public ArrayList<Long> getAttributesForGroup(long groupId) throws ApplicationException {
        ArrayList<Long> attributes = this.attributeGroups.get(groupId);
        if (attributes == null) {
            throw new ApplicationException("thre is no attribute group with id: " + groupId);
        }
        return attributes;
    }

    public long getGroupForAttribute(long attributeId) throws ApplicationException {
        Long groupId;
        if (this.reverseMap == null) {
            this.reverseMap = this.makeReverseMap();
        }
        if ((groupId = this.reverseMap.get(attributeId)) == null) {
            throw new ApplicationException("there is no attribute group for attribute id: " + attributeId);
        }
        return groupId;
    }

    public boolean hasAttributeGroup(long groupId) {
        return this.attributeGroups.containsKey(groupId) && this.attributeGroups.get(groupId) != null;
    }

    public int getIndexForAttributeId(long groupId, long attributeId) throws ApplicationException {
        int index = this.attributeGroups.get(groupId).indexOf(attributeId);
        if (index < 0) {
            throw new ApplicationException(String.format("attribute id %d in group %d not found", attributeId, groupId));
        }
        return index;
    }

    public long getAttributeIdForIndex(long groupId, int index) throws ApplicationException {
        return this.attributeGroups.get(groupId).get(index);
    }

    protected HashMap<Long, Long> makeReverseMap() throws ApplicationException {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (long groupId : this.attributeGroups.keySet()) {
            ArrayList<Long> attributes = this.attributeGroups.get(groupId);
            for (long attributeId : attributes) {
                if (map.containsKey(attributeId)) {
                    throw new ApplicationException("key already exists (must be unique!): " + attributeId);
                }
                map.put(attributeId, groupId);
            }
        }
        return map;
    }
}

