/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.data;

import java.util.Map;
import org.genemania.engine.core.data.Data;
import org.genemania.exception.ApplicationException;

public class GoIds
extends Data {
    private static final long serialVersionUID = 8553816706315210693L;
    private String goBranch;
    private String[] goIds;
    private Map<String, Integer> reverseMap;

    public GoIds(long organismId, String goBranch) {
        super("CORE", organismId);
        this.goBranch = goBranch;
    }

    public String[] getGoIds() {
        return this.goIds;
    }

    public void setGoIds(String[] goIds) {
        this.goIds = goIds;
    }

    public String getGoBranch() {
        return this.goBranch;
    }

    public void setGoBranch(String goBranch) {
        this.goBranch = goBranch;
    }

    @Override
    public String[] getKey() {
        return new String[]{this.getNamespace(), "" + this.getOrganismId(), this.goBranch + ".GoIds"};
    }

    public String getIdForIndex(int index) throws ApplicationException {
        try {
            return this.goIds[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new ApplicationException("there is no id at index postion: " + index);
        }
    }

    public int getIndexForId(String id) throws ApplicationException {
        Integer index;
        if (this.reverseMap == null) {
            this.reverseMap = Data.makeReverseMap(this.goIds);
        }
        if ((index = this.reverseMap.get(id)) == null) {
            throw new ApplicationException("there is no index position for node id: " + id);
        }
        return index;
    }
}

