/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration.calculators;

import java.util.Collection;
import no.uib.cipr.matrix.Vector;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.integration.CombineNetworksOnly;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.integration.attribute.QueryEnrichedAttributeScorer;
import org.genemania.engine.core.integration.calculators.AbstractNetworkWeightCalculator;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class AverageByCategoryCalculator
extends AbstractNetworkWeightCalculator {
    private static int MIN_QUERY_GENES_PER_ATTRIBUTE = 1;
    public static final String PARAM_KEY_FORMAT = "%s-%s";

    public AverageByCategoryCalculator(String namespace, DataCache cache, Collection<Collection<Long>> networkIds, Collection<Long> attributeGroupIds, long organismId, Vector label, int attributesLimit, ProgressReporter progress) throws ApplicationException {
        super(namespace, cache, networkIds, attributeGroupIds, organismId, label, attributesLimit, progress);
    }

    @Override
    public void process() throws ApplicationException {
        this.progress.setStatus("computing network weights");
        this.progress.setProgress(1);
        QueryEnrichedAttributeScorer attributeScorer = new QueryEnrichedAttributeScorer(this.cache, this.label, MIN_QUERY_GENES_PER_ATTRIBUTE);
        FeatureList featureList = this.buildFeatureList(attributeScorer, true);
        this.weights = AverageByCategoryCalculator.averageCategory(featureList);
        this.progress.setStatus("building combined network");
        this.progress.setProgress(2);
        this.combinedMatrix = CombineNetworksOnly.combine(this.weights, this.namespace, this.organismId, this.cache, this.progress);
    }

    protected static FeatureWeightMap averageCategory(FeatureList features) throws ApplicationException {
        FeatureWeightMap weightMap = new FeatureWeightMap();
        Collection<FeatureList> groups = features.group();
        int numGroups = groups.size();
        for (FeatureList featureList : groups) {
            int numFeatures = featureList.size();
            double weight = 1.0 / ((double)numGroups * (double)numFeatures);
            for (Feature feature : featureList) {
                weightMap.put(feature, weight);
            }
        }
        return weightMap;
    }

    @Override
    public String getParameterKey() throws ApplicationException {
        if (this.attributeGroupIds != null && this.attributeGroupIds.size() > 0) {
            throw new ApplicationException("not cacheable");
        }
        String networks = AverageByCategoryCalculator.formattedNetworkList(this.networkIds);
        return String.format(PARAM_KEY_FORMAT, new Object[]{Constants.CombiningMethod.AVERAGE_CATEGORY, networks});
    }
}

