/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration.gram;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import org.apache.log4j.Logger;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.data.AttributeData;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.engine.core.integration.FeatureLoader;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.integration.Solver;
import org.genemania.engine.exception.CancellationException;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class AutomaticGramBuilder {
    private static Logger logger = Logger.getLogger(AutomaticGramBuilder.class);
    DataCache cache;
    String namespace;
    long organismId;
    FeatureList featureList;
    no.uib.cipr.matrix.Vector labels;
    ProgressReporter progress;

    public AutomaticGramBuilder(DataCache cache, String namespace, long organismId, FeatureList featureList, no.uib.cipr.matrix.Vector labels, ProgressReporter progress) {
        this.cache = cache;
        this.namespace = namespace;
        this.organismId = organismId;
        this.featureList = new FeatureList(featureList, true);
        this.labels = labels;
        this.progress = progress;
    }

    public FeatureWeightMap build(ProgressReporter reporter) throws ApplicationException {
        this.featureList.validate();
        int[] ixPos = MatrixUtils.find(this.labels, 1.0);
        int[] ixNeg = MatrixUtils.find(this.labels, -1.0);
        int numPos = ixPos.length;
        int numNeg = ixNeg.length;
        int numFeatures = this.featureList.size();
        int numPosPos = numPos * (numPos - 1);
        int numPosNeg = 2 * numPos * numNeg;
        double biasVal = 1.0 / (double)(numPosPos + numPosNeg);
        double posConst = 2.0 * (double)numNeg / (double)(numPos + numNeg);
        double negConst = -2.0 * (double)numPos / (double)(numPos + numNeg);
        double posPosTarget = posConst * posConst;
        double posNegTarget = posConst * negConst;
        DenseMatrix KtK2 = new DenseMatrix(numFeatures, numFeatures);
        DenseVector KtT2 = new DenseVector(numFeatures);
        KtK2.set(0, 0, biasVal);
        double sumOfTargets = posPosTarget * (double)numPosPos + posNegTarget * (double)numPosNeg;
        KtT2.set(0, biasVal * sumOfTargets);
        SymMatrix[] Wpp = new SymMatrix[numFeatures];
        org.genemania.engine.matricks.Matrix[] Wpn = new org.genemania.engine.matricks.Matrix[numFeatures];
        boolean oldMode = false;
        boolean scaled = true;
        FeatureLoader featureLoader = new FeatureLoader(this.cache, this.namespace, this.organismId, oldMode, scaled);
        for (int ii = 1; ii < numFeatures; ++ii) {
            Feature feature_ii = (Feature)this.featureList.get(ii);
            Wpp[ii] = featureLoader.load(feature_ii, ixPos);
            Wpn[ii] = featureLoader.load(feature_ii, ixPos, ixNeg);
            double ssWpp = Wpp[ii].elementSum();
            double ssWpn = Wpn[ii].elementSum();
            KtT2.set(ii, posPosTarget * ssWpp + 2.0 * posNegTarget * ssWpn);
            KtK2.set(ii, 0, biasVal * (ssWpp + 2.0 * ssWpn));
            KtK2.set(0, ii, KtK2.get(ii, 0));
            for (int jj = 1; jj <= ii; ++jj) {
                if (this.progress.isCanceled()) {
                    throw new CancellationException();
                }
                double sumOfProds = 0.0;
                sumOfProds += Wpp[ii].elementMultiplySum(Wpp[jj]);
                KtK2.set(ii, jj, sumOfProds += 2.0 * Wpn[ii].elementMultiplySum(Wpn[jj]));
                KtK2.set(jj, ii, sumOfProds);
            }
        }
        logger.debug((Object)("solving system of size " + this.featureList.size()));
        return Solver.solve((Matrix)KtK2, (no.uib.cipr.matrix.Vector)KtT2, this.featureList, this.progress);
    }

    void logAttributeCounts(long groupId) throws ApplicationException {
        AttributeData attributeSet = this.cache.getAttributeData(this.namespace, this.organismId, groupId);
        org.genemania.engine.matricks.Matrix data = attributeSet.getData();
        Vector colSums = data.columnSums();
        for (int i = 0; i < colSums.getSize(); ++i) {
            if (!(colSums.get(i) > 0.0)) continue;
            logger.debug((Object)String.format("attribute %d has col sum %f", i, colSums.get(i)));
        }
    }
}

