/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.mania;

import java.util.ArrayList;
import java.util.Collection;
import no.uib.cipr.matrix.Vector;
import org.apache.log4j.Logger;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.integration.CombinedKernelBuilder;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.mania.CalculateNetworkWeights;
import org.genemania.engine.core.propagation.PropagateLabels;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;

public class CoreMania {
    private static Logger logger = Logger.getLogger(CoreMania.class);
    private DataCache cache;
    private Vector discriminant;
    private SymMatrix partiallyCombinedKernel;
    private SymMatrix combinedKernel;
    private FeatureWeightMap featureWeights;
    private ProgressReporter progress;

    public CoreMania(DataCache cache, ProgressReporter progress) {
        this.cache = cache;
        this.progress = progress;
    }

    public CoreMania(DataCache cache) {
        this(cache, NullProgressReporter.instance());
    }

    public void compute(String namespace, long organismId, Vector labels, Constants.CombiningMethod combiningMethod, Collection<Collection<Long>> networkIds, Collection<Long> attributeGroupIds, int attributesLimit, String goCategory, String biasingMethod) throws ApplicationException {
        long t1 = System.nanoTime();
        this.computeWeights(namespace, organismId, labels, combiningMethod, networkIds, attributeGroupIds, attributesLimit);
        this.computeDiscriminant("CORE", organismId, labels, goCategory, biasingMethod);
        long t2 = System.nanoTime();
        logger.info((Object)("total time for compute: " + (t2 - t1)));
    }

    public void compute(String namespace, long organismId, Vector labels, Constants.CombiningMethod combiningMethod, Collection<Collection<Long>> networkIds, String goCategory, String biasingMethod) throws ApplicationException {
        ArrayList<Long> emptyAttributeGroupList = new ArrayList<Long>();
        this.compute(namespace, organismId, labels, combiningMethod, networkIds, emptyAttributeGroupList, 0, goCategory, biasingMethod);
    }

    public void computeWeights(String namespace, long organismId, Vector labels, Constants.CombiningMethod combiningMethod, Collection<Collection<Long>> networkIds, Collection<Long> attributeGroupIds, int attributesLimit) throws ApplicationException {
        logger.info((Object)"computing weights");
        long t1 = System.nanoTime();
        CalculateNetworkWeights calculator = new CalculateNetworkWeights(namespace, this.cache, networkIds, attributeGroupIds, organismId, labels, attributesLimit, combiningMethod, this.progress);
        calculator.process();
        SymMatrix combinedKernel = calculator.getCombinedMatrix();
        FeatureWeightMap featureWeights = calculator.getWeights();
        logger.debug((Object)("# weights: " + featureWeights.size()));
        int numSparse = 0;
        int numAttribute = 0;
        for (Feature feature : featureWeights.keySet()) {
            if (feature.getType() == Constants.NetworkType.SPARSE_MATRIX) {
                ++numSparse;
                continue;
            }
            if (feature.getType() == Constants.NetworkType.ATTRIBUTE_VECTOR) {
                ++numAttribute;
                continue;
            }
            throw new ApplicationException("unexpected feature type");
        }
        logger.debug((Object)String.format("# sparse: %d, # attribute %d", numSparse, numAttribute));
        if (Config.instance().isCombinedNetworkRenormalizationEnabled()) {
            throw new ApplicationException("renormalization of combined network not supported");
        }
        this.partiallyCombinedKernel = combinedKernel;
        this.featureWeights = featureWeights;
        long t2 = System.nanoTime();
        logger.info((Object)("time for computeWeights: " + (t2 - t1)));
    }

    public void computeDiscriminant(String namespace, long organismId, Vector labels, String goCategory, String biasingMethod) throws ApplicationException {
        logger.info((Object)"computing scores");
        long t1 = System.nanoTime();
        Vector discriminant = null;
        if (biasingMethod.equalsIgnoreCase("hierarchy")) {
            logger.info((Object)"using GO hierarchy label bias method");
            throw new ApplicationException("hierarchical biasing not implemented");
        }
        if (!biasingMethod.equalsIgnoreCase("average")) {
            throw new ApplicationException("illegal biasing method name");
        }
        logger.info((Object)"using average label bias method");
        discriminant = PropagateLabels.process(this.getCombinedKernel(organismId, namespace), labels, this.progress);
        this.discriminant = discriminant;
        long t2 = System.nanoTime();
        logger.info((Object)("time for computeDiscriminant: " + (t2 - t1)));
    }

    public Vector getDiscriminant() {
        return this.discriminant;
    }

    public SymMatrix getPartiallyCombinedKernel() {
        return this.partiallyCombinedKernel;
    }

    public SymMatrix getCombinedKernel(long organismId, String namespace) throws ApplicationException {
        if (this.combinedKernel == null) {
            if (this.partiallyCombinedKernel == null && this.featureWeights == null) {
                return null;
            }
            CombinedKernelBuilder builder = new CombinedKernelBuilder(this.cache);
            this.combinedKernel = builder.build(organismId, namespace, this.partiallyCombinedKernel, this.featureWeights);
        }
        return this.combinedKernel;
    }

    public FeatureWeightMap getFeatureWeights() {
        return this.featureWeights;
    }
}

