/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.propagation;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.CG;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;
import org.apache.log4j.Logger;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.exception.PropagationFailedException;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.custom.EyePlusLaplacianMatrix;
import org.genemania.engine.matricks.mtj.SymWrap;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class PropagateLabels {
    private static Logger logger = Logger.getLogger(PropagateLabels.class);

    public static Vector process(SymMatrix network, Vector labels, ProgressReporter progress) throws ApplicationException {
        progress.setStatus("computing gene scores");
        progress.setProgress(3);
        int n = network.numCols();
        DenseVector score = new DenseVector(n);
        PropagateLabels.setLabelBiases(labels);
        EyePlusLaplacianMatrix laplacian = new EyePlusLaplacianMatrix(network);
        try {
            SymWrap w = new SymWrap(laplacian);
            CG cg = new CG((Vector)new DenseVector(labels.size()));
            cg.setIterationMonitor((IterationMonitor)new DefaultIterationMonitor(100000, 1.0E-10, 1.0E-50, 100000.0));
            cg.solve((Matrix)w, labels, (Vector)score);
        }
        catch (IterativeSolverNotConvergedException e) {
            throw new PropagationFailedException("Label propagation failed", e);
        }
        return score;
    }

    static void setLabelBiases(Vector labels) {
        int n_pos = MatrixUtils.countMatches(labels, 1.0);
        int n_neg = MatrixUtils.countMatches(labels, -1.0);
        double bias = (double)(n_pos - n_neg) * 1.0 / ((double)(n_pos + n_neg) * 1.0);
        logger.info((Object)String.format("setting label biases, npos: %s, nneg %s, bias: %s", n_pos, n_neg, bias));
        MatrixUtils.setMatches(labels, -2.0, bias);
    }
}

