/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import java.util.Arrays;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.FlexFloatArray;

public class FlexFloatColMatrix
extends AbstractMatrix {
    private static final long serialVersionUID = 8262113357006375706L;
    int rows;
    int cols;
    FlexFloatArray[] data;

    public FlexFloatColMatrix(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.alloc();
    }

    private void alloc() {
        this.data = new FlexFloatArray[this.cols];
        for (int j = 0; j < this.cols; ++j) {
            this.data[j] = new FlexFloatArray(this.rows);
        }
    }

    @Override
    public int numRows() {
        return this.rows;
    }

    @Override
    public int numCols() {
        return this.cols;
    }

    @Override
    public double get(int row, int col) {
        this.checkIdx(row, col);
        return this.data[col].get(row);
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        this.checkIdx(row, col);
        this.data[col].set(row, (float)val);
    }

    private void checkIdx(int row, int col) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException(String.format("invalid row index: %d", row));
        }
        if (col < 0 || col >= this.cols) {
            throw new IndexOutOfBoundsException(String.format("invalid column index: %d", col));
        }
    }

    @Override
    public MatrixCursor cursor() {
        return new FlexFloatColMatrixCursor();
    }

    @Override
    public double elementMultiplySum(Matrix m) {
        if (m instanceof FlexFloatColMatrix) {
            return this.elementMultiplySum((FlexFloatColMatrix)m);
        }
        throw new RuntimeException("not implemented for: " + m.getClass().getName());
    }

    public double elementMultiplySum(FlexFloatColMatrix m) {
        if (m.numRows() != this.rows && m.numCols() != this.cols) {
            throw new MatricksException("inconsistent dimensions");
        }
        double sum = 0.0;
        for (int j = 0; j < this.cols; ++j) {
            sum += this.data[j].dot(m.data[j]);
        }
        return sum;
    }

    @Override
    public void rowSums(double[] result) {
        for (int col = 0; col < this.cols; ++col) {
            this.data[col].addTo(result);
        }
    }

    @Override
    public void columnSums(double[] result) {
        for (int col = 0; col < this.cols; ++col) {
            result[col] = result[col] + this.data[col].elementSum();
        }
    }

    @Override
    public void mult(double[] x, double[] y) {
        Arrays.fill(y, 0.0);
        for (int col = 0; col < this.cols; ++col) {
            this.data[col].add(x[col], y);
        }
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        for (int col = 0; col < this.cols; ++col) {
            this.data[col].add(x[col], y);
        }
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        FlexFloatColMatrix subMatrix = new FlexFloatColMatrix(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            int idx = rows[i];
            for (int j = 0; j < cols.length; ++j) {
                int jdx = cols[j];
                double v = this.get(idx, jdx);
                if (v == 0.0) continue;
                subMatrix.set(i, j, v);
            }
        }
        return subMatrix;
    }

    @Override
    public void transMult(double[] x, double[] y) {
        Arrays.fill(y, 0.0);
        for (int col = 0; col < this.cols; ++col) {
            y[col] = this.data[col].dot(x);
        }
    }

    @Override
    public MatrixCursor columnCursor(final int columnIndex) {
        return new MatrixCursor(){
            MatrixCursor columnCursor;
            {
                this.columnCursor = FlexFloatColMatrix.this.data[columnIndex].cursor();
            }

            @Override
            public boolean next() {
                return this.columnCursor.next();
            }

            @Override
            public int row() {
                return this.columnCursor.row();
            }

            @Override
            public int col() {
                return columnIndex;
            }

            @Override
            public double val() {
                return this.columnCursor.val();
            }

            @Override
            public void set(double val) {
                this.columnCursor.set(val);
            }
        };
    }

    public FlexFloatArray getColumn(int columnIndex) {
        return this.data[columnIndex];
    }

    private class FlexFloatColMatrixCursor
    implements MatrixCursor {
        public int col = -1;
        public MatrixCursor colCursor;

        private FlexFloatColMatrixCursor() {
        }

        @Override
        public boolean next() {
            boolean next = this.colCursor == null ? this.getNextCursor() : this.colCursor.next();
            if (next) {
                return true;
            }
            return this.getNextCursor();
        }

        private boolean getNextCursor() {
            while (++this.col < FlexFloatColMatrix.this.data.length) {
                this.colCursor = FlexFloatColMatrix.this.data[this.col].cursor();
                boolean next = this.colCursor.next();
                if (!next) continue;
                return true;
            }
            return false;
        }

        @Override
        public int row() {
            return this.colCursor.row();
        }

        @Override
        public int col() {
            return this.col;
        }

        @Override
        public double val() {
            return this.colCursor.val();
        }

        @Override
        public void set(double val) {
            this.colCursor.set(val);
        }
    }
}

