/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.custom.AbstractMatrix;

public class MatrixView
extends AbstractMatrix {
    private static final long serialVersionUID = 2531376276219392342L;
    Matrix backing;
    int[] rows;
    int[] cols;

    public MatrixView(Matrix backing, int[] rows, int[] cols) {
        this.backing = backing;
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public int numRows() {
        return this.rows.length;
    }

    @Override
    public int numCols() {
        return this.cols.length;
    }

    @Override
    public double get(int row, int col) {
        return this.backing.get(this.rows[row], this.cols[col]);
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new MatricksException("read-only");
    }

    @Override
    public MatrixCursor cursor() {
        return new MatrixViewCursor();
    }

    @Override
    public void mult(double[] x, double[] y) {
        throw new MatricksException("not implemented");
    }

    private class MatrixViewCursor
    implements MatrixCursor {
        int i = 0;
        int j = -1;
        final int k;
        final int l;

        public MatrixViewCursor() {
            this.k = MatrixView.this.cols.length - 1;
            this.l = MatrixView.this.rows.length - 1;
        }

        @Override
        public boolean next() {
            if (this.j == this.k) {
                if (this.i < this.l) {
                    ++this.i;
                    this.j = 0;
                    return true;
                }
                return false;
            }
            ++this.j;
            return true;
        }

        @Override
        public int row() {
            return this.i;
        }

        @Override
        public int col() {
            return this.j;
        }

        @Override
        public double val() {
            return MatrixView.this.get(this.i, this.j);
        }

        @Override
        public void set(double val) {
            throw new MatricksException("view is read-only");
        }
    }
}

